/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.pool;

import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;

public class GenericObjectPoolConfigBuilder {
    private String lifoKey = "lifo";
    private String maxActiveKey = "maxActive";
    private String maxIdleKey = "maxIdle";
    private String maxWaitKey = "maxWait";
    private String minEvictableIdleTimeMillisKey = "minEvictableIdleTimeMillis";
    private String minIdleKey = "minIdle";
    private String numTestsPerEvictionRunKey = "numTestsPerEvictionRun";
    private String softMinEvictableIdleTimeMillisKey = "softMinEvictableIdleTimeMillis";
    private String testOnBorrowKey = "testOnBorrow";
    private String testOnReturnKey = "testOnReturn";
    private String testWhileIdleKey = "testWhileIdle";
    private String timeBetweenEvictionRunsMillisKey = "timeBetweenEvictionRunsMillis";
    private String whenExhaustedActionKey = "whenExhaustedAction";

    public GenericObjectPool.Config build(Map<String, String> initializationMap) {
        return this.build(initializationMap, "");
    }

    public GenericObjectPool.Config build(Map<String, String> initializationMap, String prefix) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        if (initializationMap.containsKey(prefix + this.lifoKey)) {
            config.lifo = Boolean.parseBoolean(initializationMap.get(prefix + this.lifoKey));
        }
        if (initializationMap.containsKey(prefix + this.maxActiveKey)) {
            config.maxActive = Integer.parseInt(initializationMap.get(prefix + this.maxActiveKey));
        }
        if (initializationMap.containsKey(prefix + this.maxIdleKey)) {
            config.maxIdle = Integer.parseInt(initializationMap.get(prefix + this.maxIdleKey));
        }
        if (initializationMap.containsKey(prefix + this.maxWaitKey)) {
            config.maxWait = Long.parseLong(initializationMap.get(prefix + this.maxWaitKey));
        }
        if (initializationMap.containsKey(prefix + this.minEvictableIdleTimeMillisKey)) {
            config.minEvictableIdleTimeMillis = Long.parseLong(initializationMap.get(prefix + this.minEvictableIdleTimeMillisKey));
        }
        if (initializationMap.containsKey(prefix + this.minIdleKey)) {
            config.minIdle = Integer.parseInt(initializationMap.get(prefix + this.minIdleKey));
        }
        if (initializationMap.containsKey(prefix + this.numTestsPerEvictionRunKey)) {
            config.numTestsPerEvictionRun = Integer.parseInt(initializationMap.get(prefix + this.numTestsPerEvictionRunKey));
        }
        if (initializationMap.containsKey(prefix + this.softMinEvictableIdleTimeMillisKey)) {
            config.softMinEvictableIdleTimeMillis = Long.parseLong(initializationMap.get(prefix + this.softMinEvictableIdleTimeMillisKey));
        }
        if (initializationMap.containsKey(prefix + this.testOnBorrowKey)) {
            config.testOnBorrow = Boolean.parseBoolean(initializationMap.get(prefix + this.testOnBorrowKey));
        }
        if (initializationMap.containsKey(prefix + this.testOnReturnKey)) {
            config.testOnReturn = Boolean.parseBoolean(initializationMap.get(prefix + this.testOnReturnKey));
        }
        if (initializationMap.containsKey(prefix + this.testWhileIdleKey)) {
            config.testWhileIdle = Boolean.parseBoolean(initializationMap.get(prefix + this.testWhileIdleKey));
        }
        if (initializationMap.containsKey(prefix + this.timeBetweenEvictionRunsMillisKey)) {
            config.timeBetweenEvictionRunsMillis = Long.parseLong(initializationMap.get(prefix + this.timeBetweenEvictionRunsMillisKey));
        }
        if (initializationMap.containsKey(prefix + this.whenExhaustedActionKey)) {
            config.whenExhaustedAction = Byte.parseByte(initializationMap.get(prefix + this.whenExhaustedActionKey));
        }
        return config;
    }

    public GenericObjectPoolConfigBuilder lifoKey(String lifoKey) {
        this.lifoKey = lifoKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder maxActiveKey(String maxActiveKey) {
        this.maxActiveKey = maxActiveKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder maxIdleKey(String maxIdleKey) {
        this.maxIdleKey = maxIdleKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder maxWaitKey(String maxWaitKey) {
        this.maxWaitKey = maxWaitKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder minEvictableIdleTimeMillisKey(String minEvictableIdleTimeMillisKey) {
        this.minEvictableIdleTimeMillisKey = minEvictableIdleTimeMillisKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder minIdleKey(String minIdleKey) {
        this.minIdleKey = minIdleKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder numTestsPerEvictionRunKey(String numTestsPerEvictionRunKey) {
        this.numTestsPerEvictionRunKey = numTestsPerEvictionRunKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder softMinEvictableIdleTimeMillisKey(String softMinEvictableIdleTimeMillisKey) {
        this.softMinEvictableIdleTimeMillisKey = softMinEvictableIdleTimeMillisKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder testOnBorrowKey(String testOnBorrowKey) {
        this.testOnBorrowKey = testOnBorrowKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder testOnReturnKey(String testOnReturnKey) {
        this.testOnReturnKey = testOnReturnKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder testWhileIdleKey(String testWhileIdleKey) {
        this.testWhileIdleKey = testWhileIdleKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder timeBetweenEvictionRunsMillisKey(String timeBetweenEvictionRunsMillisKey) {
        this.timeBetweenEvictionRunsMillisKey = timeBetweenEvictionRunsMillisKey;
        return this;
    }

    public GenericObjectPoolConfigBuilder whenExhaustedActionKey(String whenExhaustedActionKey) {
        this.whenExhaustedActionKey = whenExhaustedActionKey;
        return this;
    }
}

