/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.io;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.cyclades.io.FileUtils;

public class Zip {
    public static void zipDirectory(String sourceDir, String destinationFile) throws Exception {
        String eLabel = "Zip.zipDirectory: ";
        FileOutputStream dest = null;
        ZipOutputStream out = null;
        try {
            File sourceDirFile = new File(sourceDir);
            if (!sourceDirFile.exists()) {
                throw new Exception("Directory does not exist: " + sourceDir);
            }
            if (sourceDirFile.isFile()) {
                throw new Exception("Not a directory: " + sourceDir);
            }
            dest = new FileOutputStream(destinationFile);
            out = new ZipOutputStream(dest);
            Zip.addResourcesToZip(sourceDirFile, out, sourceDirFile);
        }
        catch (Exception e) {
            throw new Exception("Zip.zipDirectory: " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addResourcesToZip(File sourceFile, ZipOutputStream out, File base) throws Exception {
        String eLabel = "Zip.addResourcesToZip: ";
        try {
            FileInputStream fis = null;
            File[] children = sourceFile.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isFile()) {
                    Zip.addResourcesToZip(children[i], out, base);
                    continue;
                }
                try {
                    fis = new FileInputStream(children[i]);
                    ZipEntry entry = new ZipEntry(children[i].getAbsolutePath().substring(base.getAbsolutePath().length() + 1));
                    out.putNextEntry(entry);
                    ByteStreams.copy((InputStream)fis, (OutputStream)out);
                    out.closeEntry();
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Zip.addResourcesToZip: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipDirectory(String sourceFile, String destinationDirectory) throws Exception {
        String eLabel = "Zip.unzipDirectory: ";
        FileInputStream fis = null;
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            ZipEntry entry;
            fis = new FileInputStream(sourceFile);
            zis = new ZipInputStream(fis);
            FileUtils.verifyOutputDirectory(destinationDirectory);
            StringBuilder sb = new StringBuilder();
            while ((entry = zis.getNextEntry()) != null) {
                sb.setLength(0);
                String targetResource = sb.append(destinationDirectory).append("/").append(entry.getName()).toString();
                FileUtils.verifyFileOutputDirectory(targetResource);
                try {
                    fos = new FileOutputStream(targetResource);
                    ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Zip.unzipDirectory: " + e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

