/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.io;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.cyclades.io.ResourceRequestUtils;

public class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static void write(String URI2, OutputStream out) throws Exception {
        StreamUtils.write(URI2, out, 1024);
    }

    public static void write(String URI2, OutputStream out, int bufferSize) throws Exception {
        InputStream is = null;
        try {
            if (bufferSize < 1) {
                throw new Exception("Invalid buffer size: " + bufferSize);
            }
            is = ResourceRequestUtils.getInputStream(URI2, null);
            StreamUtils.write(is, out);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignore) {}
        }
    }

    public static void write(InputStream is, OutputStream out) throws Exception {
        StreamUtils.write(is, out, 1024);
    }

    public static void write(InputStream is, OutputStream out, int bufferSize) throws Exception {
        String eLabel = "StreamUtils.write(InputStream, OutputStream): ";
        try {
            int bytesRead;
            if (bufferSize < 1) {
                throw new Exception("Invalid buffer size: " + bufferSize);
            }
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = is.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new Exception("StreamUtils.write(InputStream, OutputStream): " + e);
        }
    }

    public static byte[] toByteArray(InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.write(is, (OutputStream)baos);
        return baos.toByteArray();
    }
}

