/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.cyclades.io.StreamUtils;

public class ResourceRequestUtils {
    public static InputStream getInputStream(String URLString, byte[] data) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStream: ";
        try {
            return ResourceRequestUtils.getInputStream(URLString, data, null);
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStream: " + e + " " + URLString);
        }
    }

    public static InputStream getInputStream(String URLString, byte[] data, Map<String, String> headerProperties) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStream: ";
        try {
            if (URLString.toLowerCase().startsWith("http")) {
                return ResourceRequestUtils.getInputStreamHTTP(URLString, data, headerProperties, 0, 0);
            }
            return ResourceRequestUtils.getInputStreamFile(URLString);
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStream: " + e + " " + URLString);
        }
    }

    public static InputStream getInputStream(String URLString, byte[] data, Map<String, String> headerProperties, int connectionTimeoutInMS, int readTimeoutInMS) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStream: ";
        try {
            if (URLString.toLowerCase().startsWith("http")) {
                return ResourceRequestUtils.getInputStreamHTTP(URLString, data, headerProperties, connectionTimeoutInMS, readTimeoutInMS);
            }
            return ResourceRequestUtils.getInputStreamFile(URLString);
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStream: " + e + " " + URLString);
        }
    }

    public static InputStream getInputStreamHTTP(String URLString, byte[] data) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStreamHTTP(String, byte[]): ";
        try {
            return ResourceRequestUtils.getInputStreamHTTP(URLString, data, null);
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStreamHTTP(String, byte[]): " + e + " " + URLString);
        }
    }

    public static InputStream getInputStreamHTTP(String URLString, byte[] data, Map<String, String> headerProperties) throws Exception {
        return ResourceRequestUtils.getInputStreamHTTP(URLString, data, headerProperties, 0, 0);
    }

    public static InputStream getInputStreamHTTP(String URLString, byte[] data, Map<String, String> headerProperties, int connectionTimeoutInMS, int readTimeoutInMS) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStreamHTTP: ";
        OutputStream os = null;
        try {
            URL url = new URL(URLString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (connectionTimeoutInMS > 0) {
                conn.setConnectTimeout(connectionTimeoutInMS);
            }
            if (readTimeoutInMS > 0) {
                conn.setReadTimeout(readTimeoutInMS);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (headerProperties != null) {
                for (String prop : headerProperties.keySet()) {
                    conn.setRequestProperty(prop, headerProperties.get(prop));
                }
            }
            if (data != null) {
                conn.setRequestMethod("POST");
                os = conn.getOutputStream();
                os.write(data);
                os.flush();
            } else {
                conn.setRequestMethod("GET");
            }
            InputStream inputStream = conn.getInputStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStreamHTTP: " + e + " " + URLString);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static InputStream getInputStreamHTTP(String URLString, String method, InputStream is, Map<String, String> headerProperties, int connectionTimeoutInMS, int readTimeoutInMS) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStreamHTTP: ";
        OutputStream os = null;
        try {
            URL url = new URL(URLString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (connectionTimeoutInMS > 0) {
                conn.setConnectTimeout(connectionTimeoutInMS);
            }
            if (readTimeoutInMS > 0) {
                conn.setReadTimeout(readTimeoutInMS);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (headerProperties != null) {
                for (String prop : headerProperties.keySet()) {
                    conn.setRequestProperty(prop, headerProperties.get(prop));
                }
            }
            conn.setRequestMethod(method == null ? "POST" : method);
            if (is != null) {
                os = conn.getOutputStream();
                StreamUtils.write(is, os);
                os.flush();
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("Invalid response code returned: " + conn.getResponseCode());
            }
            InputStream inputStream = conn.getInputStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStreamHTTP: " + e + " " + URLString);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static HttpURLConnection getHttpURLConnection(String URLString, String method, InputStream is, Map<String, String> headerProperties, int connectionTimeoutInMS, int readTimeoutInMS) throws Exception {
        String eLabel = "ResourceRequestUtils.getHttpURLConnection: ";
        OutputStream os = null;
        try {
            URL url = new URL(URLString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (connectionTimeoutInMS > 0) {
                conn.setConnectTimeout(connectionTimeoutInMS);
            }
            if (readTimeoutInMS > 0) {
                conn.setReadTimeout(readTimeoutInMS);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (headerProperties != null) {
                for (String prop : headerProperties.keySet()) {
                    conn.setRequestProperty(prop, headerProperties.get(prop));
                }
            }
            conn.setRequestMethod(method == null ? "POST" : method);
            if (is != null) {
                os = conn.getOutputStream();
                StreamUtils.write(is, os);
                os.flush();
            }
            HttpURLConnection httpURLConnection = conn;
            return httpURLConnection;
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getHttpURLConnection: " + e + " " + URLString);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static InputStream getInputStreamFile(String URLString) throws Exception {
        String eLabel = "ResourceRequestUtils.getInputStreamFile: ";
        OutputStream os = null;
        try {
            File file = new File(URLString);
            if (!file.exists() || !file.isFile()) {
                throw new Exception("File resource does not exist: " + URLString);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getInputStreamFile: " + e + " " + URLString);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static byte[] getData(String URLString, byte[] data) throws Exception {
        String eLabel = "ResourceRequestUtils.getData: ";
        try {
            return ResourceRequestUtils.getData(URLString, data, null, 1024);
        }
        catch (Exception e) {
            throw new Exception("ResourceRequestUtils.getData: " + e + " " + URLString);
        }
    }

    public static byte[] getData(String URLString, byte[] data, Map<String, String> headerProperties, int bufferSize) throws Exception {
        return ResourceRequestUtils.getData(URLString, data, headerProperties, bufferSize, 0, 0);
    }

    public static byte[] getData(String URLString, byte[] data, Map<String, String> headerProperties, int bufferSize, int connectionTimeoutInMS, int readTimeoutInMS) throws Exception {
        InputStream is = null;
        try {
            is = ResourceRequestUtils.getInputStream(URLString, data, headerProperties, connectionTimeoutInMS, readTimeoutInMS);
            byte[] byArray = StreamUtils.toByteArray(is);
            return byArray;
        }
        catch (Exception e) {
            throw new Exception(e + " " + URLString);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignore) {}
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("cmd [-Dheaders] URI [POST data]");
            return;
        }
        String URLString = args[0];
        byte[] data = null;
        if (args.length > 1) {
            data = args[1].getBytes();
        }
        String headers = System.getProperty("headers");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headers != null) {
            String[] headerPairs;
            for (String headerPairString : headerPairs = headers.split("[,]")) {
                String[] headerPair = headerPairString.split("[:]");
                headerMap.put(headerPair[0], headerPair[1]);
            }
        }
        try {
            byte[] dataReturned = ResourceRequestUtils.getData(URLString, data, headerMap, 1024);
            System.out.println("SIZE:" + dataReturned.length);
            String outputString = new String(dataReturned);
            System.out.println("**********************************");
            System.out.println(outputString);
            System.out.println("**********************************");
        }
        catch (Exception e) {
            System.out.println("Main: " + e);
        }
    }
}

