/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.cyclades.io.PeekException;

public abstract class PeekingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final char peekChar;
    private ByteArrayOutputStream peekBuffer = new ByteArrayOutputStream();
    private boolean hasPeeked = false;

    public PeekingOutputStream(OutputStream out, char peekChar) {
        this.out = out;
        this.peekChar = peekChar;
    }

    @Override
    public void write(int toWrite) throws IOException {
        if (!this.hasPeeked) {
            this.peekBuffer.write(toWrite);
            if ((char)toWrite == this.peekChar) {
                byte[] data = this.peekBuffer.toByteArray();
                this.peek(data);
                this.hasPeeked = true;
                this.peekBuffer = null;
                this.out.write(data);
            }
        } else {
            this.out.write(toWrite);
        }
    }

    public abstract void peek(byte[] var1) throws PeekException;
}

