/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.cyclades.engine.validator.ParameterHasValue;
import org.cyclades.engine.validator.ValidationFaultElement;

public class ParametersURISyntaxValidator
extends ParameterHasValue {
    public ParametersURISyntaxValidator(String key) {
        super(key);
    }

    public ParametersURISyntaxValidator(String key, boolean terminal) {
        super(key, terminal);
    }

    @Override
    public ValidationFaultElement validate(List<String> values) throws Exception {
        ValidationFaultElement vfe = super.validate(values);
        if (vfe != null) {
            return vfe;
        }
        for (String v : values) {
            try {
                new URI(v);
            }
            catch (URISyntaxException e) {
                StringBuilder sb = new StringBuilder("Parameter is not a valid URI: ").append(v);
                return new ValidationFaultElement(sb.toString());
            }
        }
        return null;
    }
}

