/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.List;
import org.cyclades.engine.validator.ParameterListValidator;
import org.cyclades.engine.validator.ValidationFaultElement;

public class ParameterHasNumValues
extends ParameterListValidator {
    private Integer min = null;
    private Integer max = null;

    public ParameterHasNumValues(String key) {
        super(key);
    }

    public ParameterHasNumValues(String key, boolean terminal) {
        super(key, terminal);
    }

    public ParameterHasNumValues setMin(int min) {
        this.min = min;
        return this;
    }

    public ParameterHasNumValues setMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public ValidationFaultElement validate(List<String> parameters) throws Exception {
        int size = parameters.size();
        if (this.min != null && size < this.min || this.max != null && size > this.max) {
            StringBuilder sb = new StringBuilder("Invalid number of values for parameter \"");
            sb.append(this.getKey()).append("\". Expected number of values between (inclusive) ");
            sb.append(this.min != null ? this.min : "(Unbounded Min)").append(" and ").append(this.max != null ? this.max : "(Unbounded Max)").append(", but got ").append(size);
            return new ValidationFaultElement(sb.toString());
        }
        return null;
    }
}

