/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.util;

import java.net.InetAddress;

public class TransactionIdentifier {
    private long stamp = -1L;
    private final String prefix;

    public TransactionIdentifier(String prefix) throws Exception {
        String eLabel = "TransactionIdentifier.TransactionIdentifier: ";
        try {
            StringBuilder prefixBuilder = new StringBuilder(prefix == null ? "" : prefix);
            prefixBuilder.append(this.getShortHostName(InetAddress.getLocalHost().getHostName()));
            this.prefix = prefixBuilder.toString();
        }
        catch (Exception e) {
            throw new Exception("TransactionIdentifier.TransactionIdentifier: " + e);
        }
    }

    private String getShortHostName(String longHostName) {
        return ((String[])longHostName.split("[.]").clone())[0];
    }

    public String getTransactionID() {
        return this.prefix + "-" + this.getTransactionIDStamp();
    }

    public synchronized long getTransactionIDStamp() {
        long currentStamp = System.currentTimeMillis();
        if (currentStamp <= this.stamp) {
            currentStamp = this.stamp + 1L;
        }
        this.stamp = currentStamp;
        return currentStamp;
    }
}

