/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.util;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.cyclades.xml.generator.XMLWriter;

public class PropertyUtils {
    private static final String PROPERTIES_ATTRIBUTE = "properties";
    private static final String PROPERTY_ATTRIBUTE = "property";
    private static final String NAME_ATTRIBUTE = "name";

    public static String propertiesToJSON(Properties properties) throws Exception {
        String eLabel = "MetaResponseHelper.propertiesToJSON: ";
        try {
            StringBuilder sb = new StringBuilder("{");
            Set<Object> keySet = properties.keySet();
            int i = keySet.size();
            for (Object key : properties.keySet()) {
                sb.append("\"");
                sb.append(key);
                sb.append("\":\"");
                sb.append(properties.get(key.toString()).toString().replace("\"", "\\\""));
                sb.append("\"");
                if (--i <= 0) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            throw new Exception("MetaResponseHelper.propertiesToJSON: " + e);
        }
    }

    public static String propertiesToXML(Properties properties) throws Exception {
        String eLabel = "MetaResponseHelper.propertiesToXML: ";
        try {
            Hashtable<String, String> atts = new Hashtable<String, String>();
            XMLWriter writer = new XMLWriter(null, PROPERTIES_ATTRIBUTE, null);
            Set<Object> keySet = properties.keySet();
            int i = keySet.size();
            for (Object key : properties.keySet()) {
                atts.put(NAME_ATTRIBUTE, key.toString());
                writer.addLeafNode(PROPERTY_ATTRIBUTE, atts, properties.get(key.toString()).toString(), true);
            }
            writer.done();
            return writer.toString();
        }
        catch (Exception e) {
            throw new Exception("MetaResponseHelper.propertiesToXML: " + e);
        }
    }
}

