/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.stroma.STROMAResponse;
import org.cyclades.engine.util.GenericXMLObject;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Node;

public class XSTROMABrokerResponse {
    public static final String ERROR_CODE = "error-code";
    public static final String ERROR_MESSAGE = "error-message";
    private List<STROMAResponse> responses = new ArrayList<STROMAResponse>();
    private String serviceName;
    private int errorCode;
    private String errorMessage;
    private boolean orchestrationFault = false;
    private String transactionData = null;
    private String serviceAgent = null;
    private Map<String, List<String>> parameters = null;
    private long duration = -1L;
    public static final String PARAMETERS = "parameters";
    public static final String ORCHESTRATION_FAULT = "orchestration-fault";

    public XSTROMABrokerResponse(String responseString) throws Exception {
        this(responseString.charAt(0) == '<' ? MetaTypeEnum.XML : MetaTypeEnum.JSON, responseString);
    }

    public XSTROMABrokerResponse(MetaTypeEnum metaTypeEnum, String responseString) throws Exception {
        String eLabel = "XSTROMABrokerResponse.STROMABrokerResponse: ";
        try {
            if (metaTypeEnum.equals((Object)MetaTypeEnum.JSON)) {
                this.populate(new JSONObject(responseString));
            } else {
                this.populate(new GenericXMLObject(responseString).getRootElement());
            }
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerResponse.STROMABrokerResponse: " + e);
        }
    }

    public static XSTROMABrokerResponse parse(String responseString) throws Exception {
        return new XSTROMABrokerResponse(responseString);
    }

    private void populate(Node node) throws Exception {
        String eLabel = "XSTROMABrokerResponse.populate(Node): ";
        try {
            int i;
            this.serviceName = XMLComparitor.getAttribute(node, "service");
            this.errorCode = Integer.parseInt(XMLComparitor.getAttribute(node, ERROR_CODE));
            this.errorMessage = XMLComparitor.getAttribute(node, ERROR_MESSAGE);
            this.transactionData = XMLComparitor.getAttribute(node, "transaction-data");
            this.serviceAgent = XMLComparitor.getAttribute(node, "service-agent");
            this.orchestrationFault = XMLComparitor.getMatchingChildNodes(node, ORCHESTRATION_FAULT).size() > 0;
            Vector<Node> nodesVector = XMLComparitor.getMatchingChildNodes(node, "response");
            for (i = 0; i < nodesVector.size(); ++i) {
                this.responses.add(new STROMAResponse(nodesVector.get(i)));
            }
            nodesVector = XMLComparitor.getMatchingChildNodes(node, PARAMETERS);
            for (i = 0; i < nodesVector.size(); ++i) {
                this.parameters = MapHelper.parameterMapFromMetaObject(nodesVector.get(i).getChildNodes());
            }
            nodesVector = XMLComparitor.getMatchingChildNodes(node, "duration");
            if (nodesVector.size() > 0) {
                this.duration = Long.parseLong(XMLComparitor.getAttribute(nodesVector.firstElement(), "val"));
            }
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerResponse.populate(Node): " + e);
        }
    }

    private void populate(JSONObject jsonObject) throws Exception {
        String eLabel = "XSTROMABrokerResponse.populate(JSONObject): ";
        try {
            JSONObject data;
            this.serviceName = jsonObject.getString("service");
            this.errorCode = Integer.parseInt(jsonObject.getString(ERROR_CODE));
            this.errorMessage = jsonObject.has(ERROR_MESSAGE) ? jsonObject.getString(ERROR_MESSAGE) : null;
            this.transactionData = jsonObject.has("transaction-data") ? jsonObject.getString("transaction-data") : null;
            String string = this.serviceAgent = jsonObject.has("service-agent") ? jsonObject.getString("service-agent") : null;
            if (jsonObject.has(ORCHESTRATION_FAULT)) {
                this.orchestrationFault = jsonObject.getString(ORCHESTRATION_FAULT).equalsIgnoreCase("true");
            }
            this.parameters = jsonObject.has(PARAMETERS) ? MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(PARAMETERS)) : null;
            JSONObject jSONObject = data = jsonObject.has("data") ? jsonObject.getJSONObject("data") : null;
            if (data == null || !data.has("responses")) {
                return;
            }
            JSONArray serviceResponses = data.getJSONArray("responses");
            for (int i = 0; i < serviceResponses.length(); ++i) {
                JSONObject serviceResponse = serviceResponses.getJSONObject(i);
                this.responses.add(new STROMAResponse(serviceResponse));
            }
            if (jsonObject.has("duration")) {
                this.duration = Long.parseLong(jsonObject.getString("duration"));
            }
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerResponse.populate(JSONObject): " + e);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getOrchestrationFault() {
        return this.orchestrationFault;
    }

    public String getTransactionData() {
        return this.transactionData;
    }

    public String getServiceAgent() {
        return this.serviceAgent;
    }

    public long getDuration() {
        return this.duration;
    }

    public List<STROMAResponse> getResponses() {
        return this.responses;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }
}

