/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.nyxlet.NyxletRepository;
import org.cyclades.engine.stroma.xstroma.STROMARequest;
import org.cyclades.engine.stroma.xstroma.XSTROMABrokerResponse;
import org.cyclades.engine.util.GenericXMLObject;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Node;

public class XSTROMABrokerRequest {
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private MetaTypeEnum metaTypeEnum;
    private String brokerName;
    private List<STROMARequest> serviceRequests = new ArrayList<STROMARequest>();
    private static final String BASE_PARAMETERS = "parameters";
    private static final String DATA = "data";
    private static final String REQUESTS = "requests";

    public XSTROMABrokerRequest(String brokerName, MetaTypeEnum metaTypeEnum, Map<String, List<String>> params) throws Exception {
        String eLabel = "XSTROMABrokerRequest.XSTROMABrokerRequest: ";
        try {
            this.brokerName = brokerName;
            if (params != null) {
                this.parameters = params;
            }
            this.metaTypeEnum = metaTypeEnum;
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.XSTROMABrokerRequest: " + e);
        }
    }

    public XSTROMABrokerRequest(String brokerName, byte[] xstromaMessage) throws Exception {
        this(brokerName, new String(xstromaMessage, "UTF-8"));
    }

    public XSTROMABrokerRequest(String brokerName, String messageString) throws Exception {
        this.brokerName = brokerName;
        if (messageString.charAt(0) == '<') {
            this.fromXMLXTROMAString(messageString);
        } else {
            this.fromJSONXTROMAString(messageString);
        }
    }

    private void fromXMLXTROMAString(String messageString) throws Exception {
        this.metaTypeEnum = MetaTypeEnum.XML;
        GenericXMLObject xmlObject = new GenericXMLObject(messageString);
        this.parameters = MapHelper.parameterMapFromMetaObject(XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), BASE_PARAMETERS).firstElement().getChildNodes());
        Node dataNode = XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), DATA).firstElement();
        Node requestsNode = XMLComparitor.getMatchingChildNodes(dataNode, REQUESTS).firstElement();
        for (Node requestNode : XMLComparitor.getMatchingChildNodes(requestsNode, "request")) {
            this.addSTROMARequest(new STROMARequest(requestNode));
        }
    }

    private void fromJSONXTROMAString(String messageString) throws Exception {
        this.metaTypeEnum = MetaTypeEnum.JSON;
        JSONObject jsonObject = new JSONObject(messageString);
        this.parameters = MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(BASE_PARAMETERS));
        JSONObject dataJSONObject = jsonObject.getJSONObject(DATA);
        JSONArray requestsJSONArray = dataJSONObject.getJSONArray(REQUESTS);
        for (int i = 0; i < requestsJSONArray.length(); ++i) {
            this.addSTROMARequest(new STROMARequest(requestsJSONArray.getJSONObject(i)));
        }
    }

    public static XSTROMABrokerResponse execute(String brokerName, MetaTypeEnum metaTypeEnum, Map<String, List<String>> parameters, InputStream is) throws Exception {
        String eLabel = "XSTROMABrokerRequest.execute: ";
        try {
            Nyxlet brokerNyxlet = NyxletRepository.getStaticInstance().getNyxlet(brokerName);
            if (brokerNyxlet == null) {
                throw new Exception("Service not found: " + brokerName);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (metaTypeEnum != null) {
                parameters.put("data-type", new ArrayList<String>(Arrays.asList(metaTypeEnum.name().toLowerCase())));
            }
            brokerNyxlet.process(parameters, is, baos);
            return new XSTROMABrokerResponse(metaTypeEnum, baos.toString());
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.execute: " + e);
        }
    }

    public XSTROMABrokerResponse execute() throws Exception {
        String eLabel = "XSTROMABrokerRequest.execute: ";
        try {
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(this.brokerName);
            if (mod == null) {
                throw new Exception("Service not found: " + this.brokerName);
            }
            return this.execute(mod);
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.execute: " + e);
        }
    }

    public XSTROMABrokerResponse execute(Nyxlet brokerNyxlet) throws Exception {
        String eLabel = "XSTROMABrokerRequest.execute: ";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name().toLowerCase())));
            this.parameters.put(DATA, new ArrayList<String>(Arrays.asList(this.generateData())));
            brokerNyxlet.process(this.parameters, null, baos);
            return new XSTROMABrokerResponse(this.metaTypeEnum, baos.toString());
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.execute: " + e);
        }
    }

    public void execute(OutputStream os) throws Exception {
        String eLabel = "XSTROMABrokerRequest.execute(OutputStream): ";
        try {
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(this.brokerName);
            if (mod == null) {
                throw new Exception("Service not found: " + this.brokerName);
            }
            this.execute(mod, os);
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.execute(OutputStream): " + e);
        }
    }

    public void execute(Nyxlet brokerNyxlet, OutputStream os) throws Exception {
        String eLabel = "XSTROMABrokerRequest.execute(Nyxlet, OutputStream): ";
        try {
            this.parameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name().toLowerCase())));
            this.parameters.put(DATA, new ArrayList<String>(Arrays.asList(this.generateData())));
            brokerNyxlet.process(this.parameters, null, os);
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.execute(Nyxlet, OutputStream): " + e);
        }
    }

    public void addSTROMARequest(String serviceName, Map<String, List<String>> params, String data) throws Exception {
        String eLabel = "XSTROMABrokerRequest.addSTROMARequest: ";
        try {
            this.addSTROMARequest(new STROMARequest(serviceName, params, data));
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.addSTROMARequest: " + e);
        }
    }

    public void addSTROMARequest(STROMARequest stromaRequest) throws Exception {
        String eLabel = "XSTROMABrokerRequest.addSTROMARequest: ";
        try {
            this.serviceRequests.add(stromaRequest);
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.addSTROMARequest: " + e);
        }
    }

    public void setSTROMARequests(List<STROMARequest> serviceRequests) {
        this.serviceRequests = serviceRequests;
    }

    public List<STROMARequest> getSTROMARequests() {
        return this.serviceRequests;
    }

    public String generateData() throws Exception {
        return this.metaTypeEnum.equals((Object)MetaTypeEnum.XML) ? this.generateXMLData() : this.generateJSONData();
    }

    public String generateJSONData() throws Exception {
        String eLabel = "XSTROMABrokerRequest.generateJSONData: ";
        try {
            StringBuilder builder = new StringBuilder("{\"requests\":[");
            int i = 0;
            for (STROMARequest request : this.serviceRequests) {
                if (i++ > 0) {
                    builder.append(",");
                }
                builder.append(request.toJSONString());
            }
            builder.append("]}");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.generateJSONData: " + e);
        }
    }

    public String generateXMLData() throws Exception {
        String eLabel = "XSTROMABrokerRequest.generateXMLData: ";
        try {
            StringBuilder builder = new StringBuilder("<data><requests>");
            for (STROMARequest request : this.serviceRequests) {
                builder.append(request.toXMLString());
            }
            builder.append("</requests></data>");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.generateXMLData: " + e);
        }
    }

    public String toString() {
        try {
            return this.toXSTROMAMessage();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toXSTROMAMessage() throws Exception {
        return this.metaTypeEnum.equals((Object)MetaTypeEnum.XML) ? this.toXMLXSTROMAMessage() : this.toJSONXSTROMAMessage();
    }

    public String toJSONXSTROMAMessage() throws Exception {
        StringBuilder builder = new StringBuilder("{\"");
        builder.append(BASE_PARAMETERS).append("\":");
        builder.append(MapHelper.parameterMapToJSON(this.parameters));
        builder.append(",\"data\":{\"requests\":[");
        int i = 0;
        for (STROMARequest request : this.serviceRequests) {
            if (i++ > 0) {
                builder.append(",");
            }
            builder.append(request.toJSONString());
        }
        builder.append("]}}");
        return builder.toString();
    }

    public String toXMLXSTROMAMessage() throws Exception {
        String eLabel = "XSTROMABrokerRequest.generateXMLData: ";
        try {
            StringBuilder builder = new StringBuilder("<x-stroma>");
            builder.append("<").append(BASE_PARAMETERS).append(">");
            builder.append(MapHelper.parameterMapToXML(this.parameters, "parameter"));
            builder.append("</").append(BASE_PARAMETERS).append(">");
            builder.append("<data><requests>");
            for (STROMARequest request : this.serviceRequests) {
                builder.append(request.toXMLString());
            }
            builder.append("</requests></data></x-stroma>");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("XSTROMABrokerRequest.generateXMLData: " + e);
        }
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public MetaTypeEnum getMetaTypeEnum() {
        return this.metaTypeEnum;
    }

    public void setMetaTypeEnum(MetaTypeEnum metaTypeEnum) {
        this.metaTypeEnum = metaTypeEnum;
    }
}

