/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.stroma.xstroma.STROMARequest;

public class STROMARequestBuilder {
    private final String serviceName;
    private String data = null;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private MetaTypeEnum metaTypeEnum = MetaTypeEnum.JSON;

    public static STROMARequestBuilder newInstance(String serviceName) {
        return new STROMARequestBuilder(serviceName);
    }

    public STROMARequestBuilder(String serviceName) {
        this.serviceName = serviceName;
    }

    public STROMARequestBuilder data(String data) {
        this.data = data;
        return this;
    }

    public STROMARequestBuilder parameter(String key, String value) {
        List<String> values = this.parameters.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(key, values);
        }
        values.add(value);
        return this;
    }

    public STROMARequestBuilder parameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public STROMARequestBuilder json() {
        this.metaTypeEnum = MetaTypeEnum.JSON;
        return this;
    }

    public STROMARequestBuilder xml() {
        this.metaTypeEnum = MetaTypeEnum.XML;
        return this;
    }

    public STROMARequest build() throws Exception {
        return new STROMARequest(this.serviceName, this.metaTypeEnum, this.parameters, this.data);
    }
}

