/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.nyxlet.NyxletRepository;
import org.cyclades.engine.stroma.STROMAResponse;

public class STROMAServiceRequest {
    public static final String ERROR_CODE = "error-code";
    public static final String ERROR_MESSAGE = "error-message";
    protected Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    protected MetaTypeEnum metaTypeEnum = MetaTypeEnum.JSON;
    protected String data;
    protected String serviceName;

    public STROMAServiceRequest() {
    }

    public STROMAServiceRequest(String serviceName, MetaTypeEnum metaTypeEnum, Map<String, List<String>> params, String data) throws Exception {
        String eLabel = "STROMAServiceRequest.STROMAServiceRequest: ";
        try {
            this.serviceName = serviceName;
            if (params != null) {
                this.parameters = params;
            }
            this.metaTypeEnum = metaTypeEnum;
            this.data = data;
        }
        catch (Exception e) {
            throw new Exception("STROMAServiceRequest.STROMAServiceRequest: " + e);
        }
    }

    public STROMAResponse execute() throws Exception {
        String eLabel = "STROMAServiceRequest.execute: ";
        try {
            if (this.parameters.containsKey("raw-response")) {
                throw new Exception("Parameter \"raw-response\" permitted only in \"execute(OutputStream)\"");
            }
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(this.serviceName);
            if (mod == null) {
                throw new Exception("Service not found: " + this.serviceName);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name().toLowerCase())));
            if (this.data != null) {
                this.parameters.put("data", new ArrayList<String>(Arrays.asList(this.data)));
            }
            mod.process(this.parameters, null, baos);
            return STROMAResponse.fromBytes(this.metaTypeEnum, baos.toByteArray());
        }
        catch (Exception e) {
            throw new Exception("STROMAServiceRequest.execute: " + e);
        }
    }

    public void execute(OutputStream os) throws Exception {
        String eLabel = "STROMAServiceRequest.execute(OutputStream): ";
        try {
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(this.serviceName);
            if (mod == null) {
                throw new Exception("Service not found: " + this.serviceName);
            }
            this.parameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name().toLowerCase())));
            if (this.data != null) {
                this.parameters.put("data", new ArrayList<String>(Arrays.asList(this.data)));
            }
            mod.process(this.parameters, null, os);
        }
        catch (Exception e) {
            throw new Exception("STROMAServiceRequest.execute(OutputStream): " + e);
        }
    }

    public static void execute(String serviceName, NyxletSession nyxletSession) throws Exception {
        String eLabel = "STROMAServiceRequest.execute(NyxletSession): ";
        try {
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(serviceName);
            if (mod == null) {
                throw new Exception("Service not found: " + serviceName);
            }
            mod.process(nyxletSession);
        }
        catch (Exception e) {
            throw new Exception("STROMAServiceRequest.execute(NyxletSession): " + e);
        }
    }
}

