/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.XXMLStreamWriter;
import org.json.JSONObject;

public class STROMAResponseWriter {
    private String serviceName;
    private String action;
    private String transactionData;
    private String serviceAgent;
    private OutputStream outputStream;
    private boolean isXML = false;
    private boolean responseInFlight = false;
    private boolean done = false;
    private boolean rawResponseRequested = false;
    private boolean durationRequested = false;
    private long durationStart;
    private XXMLStreamWriter xxmlStreamWriter = null;
    private boolean isJSONStreamWriter = false;
    private Map<String, List<String>> responseParameterMap = null;
    private static final String ERROR_CODE_ATTRIBUTE = "error-code";
    private static final String ERROR_MESSAGE_ATTRIBUTE = "error-message";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String DATA_ATTRIBUTE = "data";
    private static final String RESPONSE_ATTRIBUTE = "response";
    private static final String TRANSACTION_DATA_ATTRIBUTE = "transaction-data";
    private static final String PARAMETERS_ATTRIBUTE = "parameters";
    private static final String DURATION_ATTRIBUTE = "duration";

    public STROMAResponseWriter(String serviceName, NyxletSession nyxletSession) throws Exception {
        this(serviceName, nyxletSession, null);
    }

    public STROMAResponseWriter(String serviceName, NyxletSession nyxletSession, Nyxlet nyxlet) throws Exception {
        String eLabel = "STROMAResponseWriter.STROMAResponseWriter: ";
        try {
            if (nyxlet != null && nyxletSession.serviceAgentRequested()) {
                this.serviceAgent = nyxlet.getServiceAgentAttribute();
            }
            this.outputStream = nyxletSession.getOutputStream();
            this.action = nyxletSession.getActionString();
            this.transactionData = nyxletSession.getTransactionDataString();
            this.serviceName = serviceName;
            this.rawResponseRequested = nyxletSession.rawResponseRequested();
            this.durationRequested = nyxletSession.durationRequested();
            this.durationStart = nyxletSession.getDurationStart();
            switch (nyxletSession.getResponseMetaTypeEnum()) {
                case JSON: {
                    this.isXML = false;
                    break;
                }
                case XML: {
                    this.isXML = true;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.STROMAResponseWriter: " + e);
        }
    }

    public void setResponseParameters(Map<String, List<String>> responseParameterMap) throws Exception {
        if (this.done) {
            throw new Exception("Response already done");
        }
        this.responseParameterMap = responseParameterMap;
    }

    public STROMAResponseWriter addResponseParameter(String key, String value) throws Exception {
        List<String> values;
        if (this.responseParameterMap == null) {
            this.responseParameterMap = new LinkedHashMap<String, List<String>>();
        }
        if ((values = this.responseParameterMap.get(key)) == null) {
            values = new LinkedList<String>();
            this.responseParameterMap.put(key, values);
        }
        values.add(value);
        return this;
    }

    public OutputStream getOutputStream() throws Exception {
        String eLabel = "STROMAResponseWriter.getOutputStream: ";
        try {
            this.checkAndSetResponseInFlight();
            if (this.isXML) {
                this.writeXMLResponsePreMeta(null, 0);
            } else {
                this.writeJSONResponsePreMeta(null, 0);
            }
            return this.outputStream;
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.getOutputStream: " + e);
        }
    }

    public XXMLStreamWriter getXMLStreamWriter() throws Exception {
        String eLabel = "STROMAResponseWriter.getXMLStreamWriter: ";
        try {
            this.checkAndSetResponseInFlight();
            if (this.isXML) {
                XMLOutputFactory f = XMLOutputFactory.newInstance();
                f.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
                this.xxmlStreamWriter = new XXMLStreamWriter(f.createXMLStreamWriter(this.outputStream));
                this.writeXMLResponsePreMeta(null, 0);
            } else {
                this.isJSONStreamWriter = true;
                this.xxmlStreamWriter = new XXMLStreamWriter((XMLStreamWriter)new BadgerFishXMLStreamWriter((Writer)new OutputStreamWriter(this.outputStream, "UTF-8")));
                this.writeJSONResponsePreMeta(null, 0);
                this.xxmlStreamWriter.writeStartElement("root");
            }
            this.xxmlStreamWriter.suppressStartDocument(true);
            return this.xxmlStreamWriter;
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.getXMLStreamWriter: " + e);
        }
    }

    public void done() throws Exception {
        String eLabel = "STROMAResponseWriter.done: ";
        try {
            if (this.done) {
                return;
            }
            if (!this.responseInFlight) {
                if (this.isXML) {
                    this.writeResponse("");
                } else {
                    this.writeResponse("{}");
                }
            } else {
                if (this.xxmlStreamWriter != null) {
                    if (this.isJSONStreamWriter) {
                        this.xxmlStreamWriter.writeEndElement();
                    }
                    this.xxmlStreamWriter.writeEndDocument();
                    this.xxmlStreamWriter.close();
                }
                if (this.isXML) {
                    this.writeXMLResponsePostMeta();
                } else {
                    this.writeJSONResponsePostMeta();
                }
                this.done = true;
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.done: " + e);
        }
    }

    public void writeResponse(String content) throws Exception {
        this.writeAsString(content, 0);
        this.done = true;
    }

    public void writeErrorResponse(int errorCode, String errorMessage) throws Exception {
        this.writeAsString(errorMessage, errorCode);
        this.done = true;
    }

    private void writeAsString(String content, int error) throws Exception {
        String eLabel = "STROMAResponse.writeAsString: ";
        try {
            this.checkAndSetResponseInFlight();
            if (this.isXML) {
                this.writeXMLResponsePreMeta(content, error);
                if (error < 1) {
                    this.write(content);
                }
                this.writeXMLResponsePostMeta();
            } else {
                this.writeJSONResponsePreMeta(content, error);
                if (error < 1) {
                    this.write(content);
                }
                this.writeJSONResponsePostMeta();
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponse.writeAsString: " + e);
        }
    }

    private void checkAndSetResponseInFlight() throws Exception {
        this.checkResponseInFlight();
        this.responseInFlight = true;
    }

    private void checkResponseInFlight() throws Exception {
        if (this.done) {
            throw new Exception("Response already done");
        }
        if (this.responseInFlight) {
            throw new Exception("Response already in flight, no turning back now...you should be building your meta data with the OutputStream");
        }
    }

    private void writeJSONResponsePreMeta(String content, int error) throws Exception {
        String eLabel = "STROMAResponseWriter.writeJSONResponsePreMeta: ";
        try {
            if (this.rawResponseRequested) {
                return;
            }
            this.write("{\"");
            this.write(ERROR_CODE_ATTRIBUTE);
            if (error < 1) {
                this.write("\":\"0\",\"");
            } else {
                this.write("\":\"");
                this.write(String.valueOf(error));
                this.write("\",\"");
                this.write(ERROR_MESSAGE_ATTRIBUTE);
                this.write("\":");
                this.write(JSONObject.quote((String)content));
                this.write(",\"");
            }
            this.write(SERVICE_ATTRIBUTE);
            this.write("\":\"");
            this.write(this.serviceName);
            this.write("\"");
            if (this.serviceAgent != null) {
                this.write(",\"");
                this.write("service-agent");
                this.write("\":");
                this.write(JSONObject.quote((String)this.serviceAgent));
            }
            if (this.action != null) {
                this.write(",\"");
                this.write(ACTION_ATTRIBUTE);
                this.write("\":\"");
                this.write(this.action);
                this.write("\"");
            }
            if (this.transactionData != null) {
                this.write(",\"");
                this.write(TRANSACTION_DATA_ATTRIBUTE);
                this.write("\":");
                this.write(JSONObject.quote((String)this.transactionData));
            }
            if (error < 1) {
                this.write(",\"");
                this.write(DATA_ATTRIBUTE);
                this.write("\":");
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeJSONResponsePreMeta: " + e);
        }
    }

    private void writeJSONResponsePostMeta() throws Exception {
        String eLabel = "STROMAResponseWriter.writeJSONResponsePostMeta: ";
        try {
            if (this.rawResponseRequested) {
                return;
            }
            if (this.responseParameterMap != null) {
                this.write(",\"");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write("\":");
                this.write(MapHelper.parameterMapToJSON(this.responseParameterMap));
            }
            if (this.durationRequested) {
                this.write(",\"");
                this.write(DURATION_ATTRIBUTE);
                this.write("\":\"");
                this.write(String.valueOf(System.currentTimeMillis() - this.durationStart));
                this.write("\"");
            }
            this.write("}");
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeJSONResponsePostMeta: " + e);
        }
    }

    private void writeXMLResponsePreMeta(String content, int error) throws Exception {
        String eLabel = "STROMAResponseWriter.writeXMLResponsePreMeta: ";
        try {
            if (this.rawResponseRequested) {
                return;
            }
            this.write("<");
            this.write(RESPONSE_ATTRIBUTE);
            this.write(" ");
            this.writeXMLAttribute(SERVICE_ATTRIBUTE, this.serviceName, true);
            if (this.serviceAgent != null) {
                this.writeXMLAttribute("service-agent", StringEscapeUtils.escapeXml((String)this.serviceAgent), true);
            }
            if (this.action != null) {
                this.writeXMLAttribute(ACTION_ATTRIBUTE, this.action, true);
            }
            if (this.transactionData != null) {
                this.writeXMLAttribute(TRANSACTION_DATA_ATTRIBUTE, StringEscapeUtils.escapeXml((String)this.transactionData), true);
            }
            if (error < 1) {
                this.writeXMLAttribute(ERROR_CODE_ATTRIBUTE, "0", false);
            } else {
                this.writeXMLAttribute(ERROR_MESSAGE_ATTRIBUTE, StringEscapeUtils.escapeXml((String)content), true);
                this.writeXMLAttribute(ERROR_CODE_ATTRIBUTE, String.valueOf(error), false);
            }
            this.write(">");
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeXMLResponsePreMeta: " + e);
        }
    }

    private void writeXMLResponsePostMeta() throws Exception {
        String eLabel = "STROMAResponseWriter.writeXMLResponsePostMeta: ";
        try {
            if (this.rawResponseRequested) {
                return;
            }
            if (this.responseParameterMap != null) {
                this.write("<");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write(">");
                this.write(MapHelper.parameterMapToXML(this.responseParameterMap, "parameter"));
                this.write("</");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write(">");
            }
            if (this.durationRequested) {
                this.write("<");
                this.write(DURATION_ATTRIBUTE);
                this.write(" ");
                this.writeXMLAttribute("val", String.valueOf(System.currentTimeMillis() - this.durationStart), false);
                this.write("/>");
            }
            this.write("</");
            this.write(RESPONSE_ATTRIBUTE);
            this.write(">");
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeXMLResponsePostMeta: " + e);
        }
    }

    private void writeXMLAttribute(String name, String value, boolean withSpaceAfter) throws Exception {
        String eLabel = "STROMAResponseWriter.writeXMLAttribute: ";
        try {
            this.write(name);
            this.write("=\"");
            this.write(StringEscapeUtils.escapeXml((String)value));
            this.write("\"");
            if (withSpaceAfter) {
                this.write(" ");
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeXMLAttribute: " + e);
        }
    }

    private void write(String toWrite) throws Exception {
        String eLabel = "STROMAResponseWriter.write: ";
        try {
            this.outputStream.write(toWrite.getBytes());
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.write: " + e);
        }
    }
}

