/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONObject;
import org.w3c.dom.Node;

public class STROMAResponse {
    private String serviceName;
    private String action;
    private int errorCode;
    private String errorMessage;
    private Map<String, List<String>> parameters = null;
    private Object data;
    private String transactionData;
    private String serviceAgent;
    private long duration;
    public static final String ERROR_CODE = "error-code";
    public static final String ERROR_MESSAGE = "error-message";
    public static final String PARAMETERS = "parameters";

    public STROMAResponse(Object object) throws Exception {
        if (object instanceof JSONObject) {
            this.init((JSONObject)object);
        } else {
            this.init((Node)object);
        }
    }

    public STROMAResponse(String responseString) throws Exception {
        this(responseString.charAt(0) == '<' ? MetaTypeEnum.XML : MetaTypeEnum.JSON, responseString);
    }

    public STROMAResponse(MetaTypeEnum metaTypeEnum, String responseString) throws Exception {
        this(metaTypeEnum.createObjectFromMeta(responseString));
    }

    private void init(Node node) throws Exception {
        String eLabel = "STROMAResponse.STROMAResponse(Node): ";
        try {
            this.serviceName = XMLComparitor.getAttribute(node, "service");
            this.transactionData = XMLComparitor.getAttribute(node, "transaction-data");
            this.serviceAgent = XMLComparitor.getAttribute(node, "service-agent");
            this.action = XMLComparitor.getAttribute(node, "action");
            this.errorCode = Integer.parseInt(XMLComparitor.getAttribute(node, ERROR_CODE));
            this.errorMessage = XMLComparitor.getAttribute(node, ERROR_MESSAGE);
            Vector<Node> nodesVector = XMLComparitor.getMatchingChildNodes(node, PARAMETERS);
            if (nodesVector.size() > 0) {
                this.parameters = MapHelper.parameterMapFromMetaObject(nodesVector.firstElement().getChildNodes());
            }
            this.data = node;
            nodesVector = XMLComparitor.getMatchingChildNodes(node, "duration");
            if (nodesVector.size() > 0) {
                this.duration = Long.parseLong(XMLComparitor.getAttribute(nodesVector.firstElement(), "val"));
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponse.STROMAResponse(Node): " + e);
        }
    }

    private void init(JSONObject jsonObject) throws Exception {
        String eLabel = "STROMAResponse.STROMAResponse(JSONObject): ";
        try {
            this.serviceName = jsonObject.getString("service");
            this.transactionData = jsonObject.has("transaction-data") ? jsonObject.getString("transaction-data") : null;
            this.serviceAgent = jsonObject.has("service-agent") ? jsonObject.getString("service-agent") : null;
            this.action = jsonObject.has("action") ? jsonObject.getString("action") : null;
            this.errorCode = Integer.parseInt(jsonObject.getString(ERROR_CODE));
            this.errorMessage = jsonObject.has(ERROR_MESSAGE) ? jsonObject.getString(ERROR_MESSAGE) : null;
            this.parameters = jsonObject.has(PARAMETERS) ? MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(PARAMETERS)) : null;
            Object object = this.data = jsonObject.has("data") ? jsonObject.getJSONObject("data") : new JSONObject();
            if (jsonObject.has("duration")) {
                this.duration = Long.parseLong(jsonObject.getString("duration"));
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponse.STROMAResponse(JSONObject): " + e);
        }
    }

    public static STROMAResponse fromBytes(MetaTypeEnum metaTypeEnum, byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return null;
        }
        return STROMAResponse.fromString(metaTypeEnum, new String(data));
    }

    public static STROMAResponse fromString(MetaTypeEnum metaTypeEnum, String data) throws Exception {
        String eLabel = "STROMAResponse.fromString: ";
        try {
            if (data == null || data.isEmpty()) {
                return null;
            }
            return new STROMAResponse(metaTypeEnum.createObjectFromMeta(data));
        }
        catch (Exception e) {
            throw new Exception("STROMAResponse.fromString: " + e);
        }
    }

    public String getAction() {
        return this.action;
    }

    public Object getData() {
        return this.data;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTransactionData() {
        return this.transactionData;
    }

    public String getServiceAgent() {
        return this.serviceAgent;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }
}

