/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.exception.AuthException;
import org.cyclades.engine.nyxlet.templates.xstroma.ServiceBrokerNyxletImpl;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.MessageProducer;
import org.cyclades.engine.util.MapHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProducerTarget {
    private final String authenticationData;
    private final boolean authDataForwarding;
    private MessageProducer messageProducer;
    private final String theClass;
    boolean isLocal;
    private static final String AUTHENTICATION_DATA = "authentication_data";
    private static final String AUTH_DATA_FORWARDING = "auth_data_forwarding";
    private static final String AUTH_DELEGATE_OBJECT = "authDelegateObject";
    private static final String CLASS = "class";
    private static final String TARGET_INITIALIZATION_DATA = "target_init_data";
    private static final String LOCAL = "local";

    public ProducerTarget(String authenticationData, boolean authDataForwarding, String theClass, JSONObject targetInitData, boolean isLocal, ServiceBrokerNyxletImpl service) throws Exception {
        String eLabel = "ProducerTarget.ProducerTarget: ";
        try {
            this.authenticationData = authenticationData;
            this.authDataForwarding = authDataForwarding;
            this.theClass = theClass;
            this.isLocal = isLocal;
            if (!isLocal) {
                this.messageProducer = (MessageProducer)service.getClass().getClassLoader().loadClass(theClass).newInstance();
                this.messageProducer.init(MapHelper.mapFromMetaObject(targetInitData));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("ProducerTarget.ProducerTarget: " + e);
        }
    }

    public ProducerTarget(String theClass, JSONObject targetInitData) throws Exception {
        String eLabel = "ProducerTarget.ProducerTarget: ";
        try {
            this.authenticationData = null;
            this.authDataForwarding = false;
            this.theClass = theClass;
            this.messageProducer = (MessageProducer)this.getClass().getClassLoader().loadClass(theClass).newInstance();
            this.messageProducer.init(MapHelper.mapFromMetaObject(targetInitData));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("ProducerTarget.ProducerTarget: " + e);
        }
    }

    public void destroy() throws Exception {
        String eLabel = "ProducerTarget.destroy: ";
        try {
            if (this.messageProducer != null) {
                this.messageProducer.destroy();
            }
        }
        catch (Exception e) {
            throw new Exception("ProducerTarget.destroy: " + e);
        }
    }

    public String getAuthenticationData() {
        return this.authenticationData;
    }

    public boolean forwardAuthData() {
        return this.authDataForwarding;
    }

    public boolean auth(NyxletSession sessionDelegate) throws Exception {
        String eLabel = "ProducerTarget.auth: ";
        try {
            if (this.authenticationData == null) {
                return true;
            }
            return sessionDelegate.auth(sessionDelegate.getParameterMap(), this.authenticationData, false) != null;
        }
        catch (AuthException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("ProducerTarget.auth: " + e);
        }
    }

    public Map<String, List<String>> getAuthDataMap(NyxletSession sessionDelegate) throws Exception {
        String eLabel = "ProducerTarget.getAuthDataMap: ";
        try {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put(AUTH_DELEGATE_OBJECT, new ArrayList<String>(Arrays.asList(sessionDelegate.getAuthDelegateObject().toString())));
            return map;
        }
        catch (Exception e) {
            throw new Exception("ProducerTarget.getAuthDataMap: " + e);
        }
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    public static Map loadTargets(List<JSONObject> producerJSONObjectTargets, List<JSONObject> producerJSONObjectTargetAliases, ServiceBrokerNyxletImpl service) throws Exception {
        String eLabel = "ProducerTarget.loadTargets: ";
        HashMap<String, ProducerTarget> targetsMap = null;
        try {
            targetsMap = new HashMap<String, ProducerTarget>();
            for (JSONObject target : producerJSONObjectTargets) {
                boolean forwardUserData;
                JSONObject targetInitJSONObject;
                String className;
                boolean isLocal;
                String targetauthenticationData;
                String string = targetauthenticationData = target.has(AUTHENTICATION_DATA) ? target.getString(AUTHENTICATION_DATA) : null;
                if (target.has(LOCAL) && target.getString(LOCAL).equalsIgnoreCase("true")) {
                    isLocal = true;
                    className = null;
                    targetInitJSONObject = null;
                    forwardUserData = false;
                } else {
                    isLocal = false;
                    className = target.getString(CLASS);
                    targetInitJSONObject = target.getJSONObject(TARGET_INITIALIZATION_DATA);
                    forwardUserData = target.has(AUTH_DATA_FORWARDING) ? target.getString(AUTH_DATA_FORWARDING).equalsIgnoreCase("true") : false;
                }
                targetsMap.put(target.getString("target"), new ProducerTarget(targetauthenticationData, forwardUserData, className, targetInitJSONObject, isLocal, service));
            }
            for (JSONObject targetAlias : producerJSONObjectTargetAliases) {
                String targetName = targetAlias.getString("target");
                JSONArray targetAliasArray = targetAlias.getJSONArray("aliases");
                if (!targetsMap.containsKey(targetName)) {
                    throw new Exception("Target does not exist: " + targetName);
                }
                for (int j = 0; j < targetAliasArray.length(); ++j) {
                    targetsMap.put(targetAliasArray.getString(j), (ProducerTarget)targetsMap.get(targetName));
                }
            }
            return targetsMap;
        }
        catch (Exception e) {
            if (targetsMap != null) {
                for (Map.Entry entry : targetsMap.entrySet()) {
                    try {
                        ((ProducerTarget)entry.getValue()).destroy();
                    }
                    catch (Exception ex) {}
                }
            }
            throw new Exception("ProducerTarget.loadTargets: " + e);
        }
    }

    public String toString() {
        return this.theClass;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isHealthy() throws Exception {
        return this.isLocal ? true : this.messageProducer.isHealthy();
    }
}

