/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.message.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.nyxlet.templates.xstroma.message.impl.RawMessageProcessor;
import org.cyclades.engine.stroma.STROMARequestHelper;
import org.json.JSONObject;

public class ResponseProcessor
extends RawMessageProcessor {
    private final String requestInputParameterName;
    private static final String REQUEST_INPUT_PARAMETER = "request_input_parameter";

    public ResponseProcessor(JSONObject jsonObject) throws Exception {
        super(jsonObject);
        this.requestInputParameterName = jsonObject.has(REQUEST_INPUT_PARAMETER) ? jsonObject.getString(REQUEST_INPUT_PARAMETER) : null;
    }

    public void process(String responseMessage, String requestMessage) throws Exception {
        if (this.useMapChannel) {
            this.processMapChannel(responseMessage.getBytes(), requestMessage.getBytes());
        } else {
            this.processString(responseMessage, requestMessage);
        }
    }

    public String processAndGetResponse(String responseMessage, String requestMessage) throws Exception {
        if (this.useMapChannel) {
            return new String(this.processAndGetResponseMapChannel(responseMessage.getBytes(), requestMessage.getBytes()), this.stringEncoding);
        }
        return new String(this.processAndGetResponseString(responseMessage, requestMessage), this.stringEncoding);
    }

    public void process(byte[] responseMessage, byte[] requestMessage) throws Exception {
        if (this.useMapChannel) {
            this.processMapChannel(responseMessage, requestMessage);
        } else {
            this.processString(new String(responseMessage, this.stringEncoding), new String(requestMessage, this.stringEncoding));
        }
    }

    public byte[] processAndGetResponse(byte[] responseMessage, byte[] requestMessage) throws Exception {
        if (this.useMapChannel) {
            return this.processAndGetResponseMapChannel(responseMessage, requestMessage);
        }
        return this.processAndGetResponseString(new String(responseMessage, this.stringEncoding), new String(requestMessage, this.stringEncoding));
    }

    private void processString(String responseMessage, String requestMessage) throws Exception {
        STROMARequestHelper.request(this.requestParameters(responseMessage, requestMessage), this.metaTypeEnum, this.serviceName, null);
    }

    private byte[] processAndGetResponseString(String responseMessage, String requestMessage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        STROMARequestHelper.requestStreamedResponse(this.requestParameters(responseMessage, requestMessage), this.metaTypeEnum, this.serviceName, null, baos);
        return baos.toByteArray();
    }

    private void processMapChannel(byte[] responseMessage, byte[] requestMessage) throws Exception {
        Map<String, List<String>> requestParameters = this.requestParameters();
        requestParameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name())));
        HashMap<Object, Object> mapChannel = new HashMap<Object, Object>();
        mapChannel.put(this.inputParameterName, responseMessage);
        if (this.requestInputParameterName != null) {
            mapChannel.put(this.requestInputParameterName, requestMessage);
        }
        STROMARequestHelper.requestSetAndGetMapChannel(requestParameters, this.serviceName, mapChannel);
    }

    private byte[] processAndGetResponseMapChannel(byte[] responseMessage, byte[] requestMessage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Map<String, List<String>> requestParameters = this.requestParameters();
        requestParameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name())));
        HashMap<Object, Object> mapChannel = new HashMap<Object, Object>();
        mapChannel.put(this.inputParameterName, responseMessage);
        if (this.requestInputParameterName != null) {
            mapChannel.put(this.requestInputParameterName, requestMessage);
        }
        STROMARequestHelper.requestSetMapChannel(requestParameters, this.serviceName, mapChannel, baos);
        return baos.toByteArray();
    }

    private Map<String, List<String>> requestParameters(String responseMessage, String requestMessage) {
        HashMap<String, List<String>> requestParameters = new HashMap<String, List<String>>();
        requestParameters.putAll(this.fixedParameters);
        if (responseMessage != null) {
            requestParameters.put(this.inputParameterName, new ArrayList<String>(Arrays.asList(responseMessage)));
        }
        if (requestMessage != null && this.requestInputParameterName != null) {
            requestParameters.put(this.requestInputParameterName, new ArrayList<String>(Arrays.asList(requestMessage)));
        }
        return requestParameters;
    }
}

