/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.message.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.MessageProcessor;
import org.cyclades.engine.stroma.STROMARequestHelper;
import org.cyclades.engine.util.MapHelper;
import org.json.JSONObject;

public class RawMessageProcessor
implements MessageProcessor {
    protected final String serviceName;
    protected final String inputParameterName;
    protected final MetaTypeEnum metaTypeEnum;
    protected final boolean useMapChannel;
    protected final String stringEncoding;
    protected Map<String, List<String>> fixedParameters = new HashMap<String, List<String>>();
    protected static final String SERVICE_NAME = "service_name";
    protected static final String RESPONSE_INPUT_PARAMETER = "response_input_parameter";
    protected static final String INPUT_PARAMETER = "input_parameter";
    protected static final String DATA_TYPE = "data_type";
    protected static final String PARMAMETERS = "parameters";
    protected static final String USE_MAP_CHANNEL = "use_map_channel";
    protected static final String BINARY_TO_STRING_ENCODING = "encoding";

    public RawMessageProcessor(JSONObject jsonObject) throws Exception {
        this.serviceName = jsonObject.getString(SERVICE_NAME);
        this.inputParameterName = jsonObject.has(RESPONSE_INPUT_PARAMETER) ? jsonObject.getString(RESPONSE_INPUT_PARAMETER) : jsonObject.getString(INPUT_PARAMETER);
        this.metaTypeEnum = jsonObject.has(DATA_TYPE) ? MetaTypeEnum.valueOf(jsonObject.getString(DATA_TYPE).toUpperCase()) : MetaTypeEnum.JSON;
        this.useMapChannel = jsonObject.has(USE_MAP_CHANNEL) ? jsonObject.getString(USE_MAP_CHANNEL).equalsIgnoreCase("true") : false;
        String string = this.stringEncoding = jsonObject.has(BINARY_TO_STRING_ENCODING) ? jsonObject.getString(BINARY_TO_STRING_ENCODING) : "UTF-8";
        if (jsonObject.has(PARMAMETERS)) {
            this.fixedParameters = MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(PARMAMETERS));
        }
    }

    @Override
    public void process(String message) throws Exception {
        if (this.useMapChannel) {
            this.processMapChannel(message.getBytes());
        } else {
            this.processString(message);
        }
    }

    @Override
    public String processAndGetResponse(String message) throws Exception {
        if (this.useMapChannel) {
            return new String(this.processAndGetResponseMapChannel(message.getBytes()), this.stringEncoding);
        }
        return new String(this.processAndGetResponseString(message), this.stringEncoding);
    }

    @Override
    public void process(byte[] message) throws Exception {
        if (this.useMapChannel) {
            this.processMapChannel(message);
        } else {
            this.processString(new String(message, this.stringEncoding));
        }
    }

    @Override
    public byte[] processAndGetResponse(byte[] message) throws Exception {
        if (this.useMapChannel) {
            return this.processAndGetResponseMapChannel(message);
        }
        return this.processAndGetResponseString(new String(message, this.stringEncoding));
    }

    private void processString(String message) throws Exception {
        STROMARequestHelper.request(this.requestParameters(message), this.metaTypeEnum, this.serviceName, null);
    }

    private byte[] processAndGetResponseString(String message) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        STROMARequestHelper.requestStreamedResponse(this.requestParameters(message), this.metaTypeEnum, this.serviceName, null, baos);
        return baos.toByteArray();
    }

    private void processMapChannel(byte[] message) throws Exception {
        Map<String, List<String>> requestParameters = this.requestParameters();
        requestParameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name())));
        STROMARequestHelper.requestSetAndGetMapChannel(requestParameters, this.serviceName, this.inputParameterName, message, "discard");
    }

    private byte[] processAndGetResponseMapChannel(byte[] message) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Map<String, List<String>> requestParameters = this.requestParameters();
        requestParameters.put("data-type", new ArrayList<String>(Arrays.asList(this.metaTypeEnum.name())));
        STROMARequestHelper.requestSetMapChannel(requestParameters, this.serviceName, this.inputParameterName, message, baos);
        return baos.toByteArray();
    }

    protected Map<String, List<String>> requestParameters() {
        return this.requestParameters(null);
    }

    private Map<String, List<String>> requestParameters(String message) {
        HashMap<String, List<String>> requestParameters = new HashMap<String, List<String>>();
        requestParameters.putAll(this.fixedParameters);
        if (message != null) {
            requestParameters.put(this.inputParameterName, new ArrayList<String>(Arrays.asList(message)));
        }
        return requestParameters;
    }
}

