/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.message.impl;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.StreamingMessageProducer;
import org.cyclades.io.ResourceRequestUtils;

public class HTTPMessageProducer
implements StreamingMessageProducer {
    private String accessURL;
    public static final String CONNECTION_TIMEOUT = "connection-timeout";
    public static final String READ_TIMEOUT = "read-timeout";
    public static final String URI_CONFIG_PARAMETER = "uri";
    private static final Map<String, String> headerProperties = new HashMap<String, String>();

    @Override
    public void init(Map<String, String> initializationMap) throws Exception {
        if (!initializationMap.containsKey(URI_CONFIG_PARAMETER)) {
            throw new Exception("Initialization parameter missing: uri");
        }
        StringBuilder builder = new StringBuilder(initializationMap.get(URI_CONFIG_PARAMETER));
        builder.append("?").append("x-stroma-message");
        this.accessURL = builder.toString();
    }

    @Override
    public void sendMessage(String message, Map<String, List<String>> attributeMap, OutputStream os) throws Exception {
        String eLabel = "HTTPMessageProducer.sendMessage: ";
        InputStream is = null;
        try {
            int connectionTimeout = attributeMap.containsKey(CONNECTION_TIMEOUT) ? Integer.parseInt(attributeMap.get(CONNECTION_TIMEOUT).get(0)) : 0;
            int readTimeout = attributeMap.containsKey(READ_TIMEOUT) ? Integer.parseInt(attributeMap.get(READ_TIMEOUT).get(0)) : 0;
            is = ResourceRequestUtils.getInputStream(this.accessURL, message.getBytes(), headerProperties, connectionTimeout, readTimeout);
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("HTTPMessageProducer.sendMessage: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String sendMessage(String message, Map<String, List<String>> attributeMap) throws Exception {
        throw new UnsupportedOperationException("Please use the sendMessage implementation from StreamingMessageProducer");
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public boolean isHealthy() throws Exception {
        return true;
    }

    static {
        headerProperties.put("STROMA", "true");
    }
}

