/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.stroma.actionhandler;

import java.util.List;
import java.util.Map;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.nyxlet.templates.stroma.STROMANyxlet;
import org.cyclades.engine.nyxlet.templates.stroma.actionhandler.ActionHandler;
import org.cyclades.engine.stroma.STROMAResponse;
import org.cyclades.engine.stroma.STROMAResponseWriter;

public abstract class ChainableActionHandler
extends ActionHandler {
    public ChainableActionHandler(STROMANyxlet parentCommand) {
        super(parentCommand);
    }

    public Object[] getMapChannelKeyTargets(NyxletSession nyxletSession) throws Exception {
        return null;
    }

    public abstract void handleMapChannel(NyxletSession var1, Map<String, List<String>> var2, STROMAResponseWriter var3) throws Exception;

    public abstract void handleSTROMAResponse(NyxletSession var1, Map<String, List<String>> var2, STROMAResponseWriter var3, STROMAResponse var4) throws Exception;

    public abstract boolean isSTROMAResponseCompatible(STROMAResponse var1) throws Exception;

    @Override
    public void handle(NyxletSession nyxletSession, Map<String, List<String>> baseParameters, STROMAResponseWriter stromaResponseWriter) throws Exception {
        String eLabel = "ChainableActionHandler.handle: ";
        try {
            if (this.containsMapChannelKeys(nyxletSession, this.getMapChannelKeyTargets(nyxletSession))) {
                this.handleMapChannel(nyxletSession, baseParameters, stromaResponseWriter);
            } else {
                STROMAResponse stromaResponse = STROMAResponse.fromBytes(nyxletSession.getMetaTypeEnum(), nyxletSession.getPortData());
                stromaResponse = stromaResponse == null ? null : (this.isSTROMAResponseCompatible(stromaResponse) ? stromaResponse : null);
                this.handleSTROMAResponse(nyxletSession, baseParameters, stromaResponseWriter, stromaResponse);
            }
        }
        catch (Exception e) {
            this.handleException(nyxletSession, stromaResponseWriter, "ChainableActionHandler.handle: ", e);
        }
    }

    private boolean containsMapChannelKeys(NyxletSession nyxletSession, Object[] keys) throws Exception {
        String eLabel = "ChainableActionHandler.containsMapChannelKeys: ";
        try {
            if (keys == null) {
                return false;
            }
            if (keys.length == 0) {
                return true;
            }
            for (Object key : keys) {
                if (nyxletSession.containsMapChannelKey(key)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("ChainableActionHandler.containsMapChannelKeys: " + e);
        }
    }
}

