/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.stroma.actionhandler;

import java.util.List;
import java.util.Map;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.nyxlet.templates.stroma.STROMANyxlet;
import org.cyclades.engine.stroma.STROMAResponseWriter;
import org.cyclades.engine.validator.FieldValidators;

public abstract class ActionHandler {
    protected final STROMANyxlet parentNyxlet;
    protected final FieldValidators fieldValidators = new FieldValidators();

    public ActionHandler(STROMANyxlet parentNyxlet) {
        this.parentNyxlet = parentNyxlet;
    }

    public abstract void handle(NyxletSession var1, Map<String, List<String>> var2, STROMAResponseWriter var3) throws Exception;

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public static boolean parameterAsBoolean(String key, Map<String, List<String>> parameters, boolean requireValue) {
        return parameters.containsKey(key) && (parameters.get(key).get(0).isEmpty() && !requireValue || parameters.get(key).get(0).equalsIgnoreCase("true"));
    }

    public String[] getRequiredParameterKeys() throws Exception {
        return null;
    }

    public void handleException(NyxletSession nyxletSession, STROMAResponseWriter stromaResponseWriter, Exception exception) throws Exception {
        this.handleException(nyxletSession, stromaResponseWriter, null, exception, true);
    }

    public void handleException(NyxletSession nyxletSession, STROMAResponseWriter stromaResponseWriter, String prefix, Exception exception) throws Exception {
        this.handleException(nyxletSession, stromaResponseWriter, prefix, exception, true);
    }

    public void handleException(NyxletSession nyxletSession, STROMAResponseWriter stromaResponseWriter, String prefix, Exception exception, boolean raiseOrchestrationFault) throws Exception {
        prefix = prefix == null ? "" : prefix;
        this.parentNyxlet.logError(prefix + this.parentNyxlet.getName() + " " + exception, new Throwable[0]);
        if (raiseOrchestrationFault) {
            nyxletSession.raiseOrchestrationFault(prefix + exception);
        }
        stromaResponseWriter.writeErrorResponse(exception instanceof CycladesException ? ((CycladesException)exception).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), prefix + exception);
    }

    public boolean isHealthy() throws Exception {
        return true;
    }

    public boolean ignoreSTROMAParameters() {
        return false;
    }

    public STROMANyxlet getParentNyxlet() {
        return this.parentNyxlet;
    }

    public FieldValidators getFieldValidators() {
        return this.fieldValidators;
    }
}

