/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.stroma;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Priority;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.logging.LogWriter;
import org.cyclades.engine.logging.LogWriterInterface;
import org.cyclades.engine.logging.LoggingDelegate;
import org.cyclades.engine.logging.LoggingEnum;
import org.cyclades.engine.nyxlet.templates.stroma.actionhandler.ActionHandler;
import org.cyclades.engine.nyxlet.templates.stroma.actionhandler.GetServiceMetaHandler;
import org.cyclades.engine.nyxlet.templates.stroma.actionhandler.ListActionsHandler;
import org.cyclades.engine.stroma.STROMARequestParameterAggregate;
import org.cyclades.engine.stroma.STROMAResponseWriter;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.engine.util.XProperties;
import org.cyclades.engine.validator.ValidationFaultElement;
import org.cyclades.io.ResourceRequestUtils;

public abstract class STROMANyxlet
extends Nyxlet {
    protected Map<String, Object> actionHandlers = new HashMap<String, Object>();
    private Map<String, LogWriterInterface> logWriterMap = new HashMap<String, LogWriterInterface>();
    private Map<String, LoggingDelegate> loggingDelegateMap = new HashMap<String, LoggingDelegate>();
    private XProperties externalProperties = new XProperties();
    public static final String ACTION_HANDLERS = "actionHandlers";
    public static final String LOG_WRITERS = "logWriters";
    public static final String LOGGING_DELEGATES = "loggingDelegates";
    public static final String EXTERNAL_PROPERTIES = "externalProperties";
    public static final String DEFAULT_LOGGING_DELEGATE = "general";
    public static final String SUPPLEMENTAL_PROPERTIES = "supplementalProperties";

    @Override
    public byte[] process(NyxletSession nyxletSession) throws CycladesException {
        try {
            nyxletSession.setResponseContentType(nyxletSession.getDataContentType());
            this.processInternal(nyxletSession);
            return null;
        }
        catch (Exception ex) {
            this.logError(ex.getMessage() + " " + ex.toString(), new Throwable[0]);
            return this.handleError(ResponseCodeEnum.GENERAL_ERROR.getCode(), ex);
        }
    }

    protected void processInternal(NyxletSession nyxletSession) throws CycladesException {
        String eLabel = "STROMANyxlet.processInternal: ";
        String action = null;
        try {
            ActionHandler handler;
            if (!this.isActive()) {
                throw new CycladesException("This service is inactive", ResponseCodeEnum.SERVICE_INACTIVE.getCode());
            }
            Map<String, List<String>> RRDParameterMap = null;
            if (nyxletSession.isRRDRequest()) {
                RRDParameterMap = this.getRRDURIParameterMap(nyxletSession);
            }
            if ((handler = this.getActionHandler(nyxletSession.getActionString())) == null && RRDParameterMap != null && RRDParameterMap.containsKey("action")) {
                handler = this.getActionHandler(RRDParameterMap.get("action").get(0));
            }
            Map<String, List<String>> mergedBaseParameters = handler != null && handler.ignoreSTROMAParameters() ? this.baseParametersNonSTROMA(nyxletSession, RRDParameterMap) : this.baseParameters(nyxletSession, RRDParameterMap);
            action = nyxletSession.getActionString();
            if (action == null) {
                throw new Exception("No action has been specified.");
            }
            handler = this.getActionHandler(action);
            if (handler == null) {
                throw new Exception("Unknown action specified: " + action);
            }
            if (handler.getFieldValidators().size() > 0) {
                this.processFieldValidators(handler.getFieldValidators().validate(nyxletSession, mergedBaseParameters));
            }
            handler.handle(nyxletSession, mergedBaseParameters, new STROMAResponseWriter(this.getName(), nyxletSession, this));
        }
        catch (Exception e) {
            this.logError("STROMANyxlet.processInternal: " + e, new Throwable[0]);
            try {
                nyxletSession.raiseOrchestrationFault("STROMANyxlet.processInternal: " + e);
                new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "STROMANyxlet.processInternal: " + e);
            }
            catch (Exception ex) {
                nyxletSession.setResponseContentType("text/html");
                StringBuffer sb = new StringBuffer("<HTML><TITLE>STROMANyxlet</TITLE><BODY>");
                sb.append("FAILURE: " + e);
                sb.append("</BODY></HTML>");
                try {
                    nyxletSession.getOutputStream().write(sb.toString().getBytes());
                }
                catch (Exception exx) {
                    this.logError("STROMANyxlet.processInternal: " + exx, new Throwable[0]);
                }
            }
        }
    }

    private ActionHandler getActionHandler(String actionHandlerString) {
        if (actionHandlerString == null) {
            return null;
        }
        Object handler = this.actionHandlers.get(actionHandlerString);
        return handler == null ? null : (ActionHandler)handler;
    }

    private Map<String, List<String>> baseParameters(NyxletSession nyxletSession, Map<String, List<String>> additionalMap) throws Exception {
        String eLabel = "STROMANyxlet.baseParameters: ";
        try {
            Map<String, List<String>> mergedParameters = additionalMap != null ? STROMARequestParameterAggregate.getParameters(nyxletSession, MapHelper.mergeMaps(nyxletSession.getParameterMap(), additionalMap, null), null) : STROMARequestParameterAggregate.getParameters(nyxletSession, null);
            this.setReservedBaseParameters(nyxletSession, mergedParameters);
            return mergedParameters;
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.baseParameters: " + e);
        }
    }

    private Map<String, List<String>> baseParametersNonSTROMA(NyxletSession nyxletSession, Map<String, List<String>> additionalMap) throws Exception {
        String eLabel = "STROMANyxlet.baseParametersNonSTROMA: ";
        try {
            Map<String, List<String>> mergedParameters = MapHelper.immutableParameterMap(MapHelper.mergeMaps(nyxletSession.getParameterMap(), additionalMap, null));
            this.setReservedBaseParameters(nyxletSession, mergedParameters);
            return mergedParameters;
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.baseParametersNonSTROMA: " + e);
        }
    }

    private void setReservedBaseParameters(NyxletSession nyxletSession, Map<String, List<String>> mergedParameters) throws Exception {
        String eLabel = "STROMANyxlet.setReservedBaseParameters: ";
        try {
            if (mergedParameters.containsKey("action")) {
                nyxletSession.setActionObject(mergedParameters.get("action").get(0));
            }
            if (mergedParameters.containsKey("transaction-data")) {
                nyxletSession.setTransactionDataObject(mergedParameters.get("transaction-data").get(0));
            }
            if (mergedParameters.containsKey("log-level")) {
                nyxletSession.setUserLoggingLevel(Enum.valueOf(LoggingEnum.class, mergedParameters.get("log-level").get(0).toUpperCase()));
            }
            if (mergedParameters.containsKey("duration")) {
                nyxletSession.setDurationRequested(mergedParameters.get("duration").get(0).isEmpty() ? true : mergedParameters.get("duration").get(0).equalsIgnoreCase("true"));
            }
            if (mergedParameters.containsKey("service-agent")) {
                nyxletSession.setServiceAgentRequested(mergedParameters.get("service-agent").get(0).isEmpty() ? true : mergedParameters.get("service-agent").get(0).equalsIgnoreCase("true"));
            }
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.setReservedBaseParameters: " + e);
        }
    }

    public void loadActionHandlers(Set<Map.Entry<Object, Object>> actionHandlerEntrySet) throws Exception {
        Class[] parameterArray = new Class[]{STROMANyxlet.class};
        Object[] objectArray = new Object[]{this};
        HashMap<String, ActionHandler> classToObjectMap = new HashMap<String, ActionHandler>();
        for (Map.Entry<Object, Object> actionHandler : actionHandlerEntrySet) {
            ActionHandler handler = (ActionHandler)classToObjectMap.get(actionHandler.getValue().toString());
            if (handler == null) {
                handler = (ActionHandler)this.getClass().getClassLoader().loadClass(actionHandler.getValue().toString()).getConstructor(parameterArray).newInstance(objectArray);
                handler.init();
                classToObjectMap.put(actionHandler.getValue().toString(), handler);
            }
            this.actionHandlers.put(actionHandler.getKey().toString(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadActionHandlers(String propertyString) throws Exception {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(propertyString.getBytes());
            Properties props = new Properties();
            props.load(bis);
            this.actionHandlers.put("listactions", new ListActionsHandler(this));
            this.actionHandlers.put("getservicemeta", new GetServiceMetaHandler(this));
            this.loadActionHandlers(props.entrySet());
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    private void loadLogWriters(String propertyString) throws Exception {
        String eLabel = "STROMANyxlet.loadLogWriters: ";
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(propertyString.getBytes());
            Properties props = new Properties();
            props.load(bis);
            Enumeration<Object> keySet = props.keys();
            while (keySet.hasMoreElements()) {
                String writerName = (String)keySet.nextElement();
                String[] writerFields = ((String)props.get(writerName)).split("\\|");
                if (writerFields.length != 3) {
                    throw new Exception("Invalid LogWriter entry, parse error: " + writerName);
                }
                LogWriter writer = new LogWriter(STROMANyxlet.getEngineContext().getCanonicalEngineDirectoryPath(writerFields[0]), writerFields[1], writerFields[2]);
                this.logWriterMap.put(writerName, writer);
            }
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.loadLogWriters: " + e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
    }

    private void loadLoggingDelegates(String propertyString) throws Exception {
        String eLabel = "STROMANyxlet.loadLoggingDelegates: ";
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(propertyString.getBytes());
            Properties props = new Properties();
            props.load(bis);
            Enumeration<Object> keySet = props.keys();
            while (keySet.hasMoreElements()) {
                String loggingDelegateName = (String)keySet.nextElement();
                String[] fields = ((String)props.get(loggingDelegateName)).split("\\|");
                if (fields.length != 2) {
                    throw new Exception("Invalid LoggingDelegate entry, parse error: " + loggingDelegateName);
                }
                LoggingDelegate loggingDelegate = new LoggingDelegate(this.getLogWriter(fields[0]), LoggingEnum.valueOf(this.externalProperties.getProperty("LoggingDelegate." + loggingDelegateName + ".logLevel", fields[1]).toUpperCase()));
                this.loggingDelegateMap.put(loggingDelegateName, loggingDelegate);
            }
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.loadLoggingDelegates: " + e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
    }

    public LogWriterInterface getLogWriter(String writerName) throws Exception {
        String eLabel = "STROMANyxlet.getLogWriter: ";
        try {
            LogWriterInterface writer = this.logWriterMap.get(writerName);
            if (writer == null) {
                throw new Exception("Writer does not exist: " + writerName);
            }
            return writer;
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.getLogWriter: " + e);
        }
    }

    public LoggingDelegate getLoggingDelegate(String loggingDelegateName) throws Exception {
        String eLabel = "STROMANyxlet.getLoggingDelegate: ";
        try {
            LoggingDelegate loggingDelegate = this.loggingDelegateMap.get(loggingDelegateName);
            if (loggingDelegate == null) {
                throw new Exception("LoggingDelegate does not exist: " + loggingDelegateName);
            }
            return loggingDelegate;
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.getLoggingDelegate: " + e);
        }
    }

    private void closeLogWriters() throws Exception {
        String eLabel = "STROMANyxlet.closeLogWriters: ";
        try {
            for (String key : this.logWriterMap.keySet()) {
                this.logWriterMap.get(key).close();
            }
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.closeLogWriters: " + e);
        }
    }

    protected void destroyActionHandlers() throws Exception {
        for (String key : this.actionHandlers.keySet()) {
            try {
                ((ActionHandler)this.actionHandlers.get(key)).destroy();
            }
            catch (Exception ex) {
                this.logError(ex.getMessage() + " " + " Continuing to destroy remaining ActionHandlers", new Throwable[0]);
            }
        }
    }

    @Override
    public void init() throws CycladesException {
        String eLabel = "STROMANyxlet.init: ";
        try {
            String aValue = this.getAttribute(EXTERNAL_PROPERTIES);
            if (aValue != null && !aValue.isEmpty()) {
                this.loadExternalProperties(this.getAttribute(EXTERNAL_PROPERTIES));
            } else {
                this.loadExternalPropertiesDefault();
            }
            aValue = this.getAttribute(LOG_WRITERS);
            if (aValue == null) {
                this.logInfo("STROMANyxlet.init: No LogWriters defined.", new Throwable[0]);
            } else {
                this.loadLogWriters(aValue);
            }
            aValue = this.getAttribute(LOGGING_DELEGATES);
            if (aValue == null) {
                this.logInfo("STROMANyxlet.init: No LoggingDelegates defined.", new Throwable[0]);
            } else {
                this.loadLoggingDelegates(aValue);
            }
            aValue = this.getAttribute(ACTION_HANDLERS);
            if (aValue == null) {
                this.logInfo("STROMANyxlet.init: No ActionHandlers defined.", new Throwable[0]);
            } else {
                this.loadActionHandlers(aValue);
            }
        }
        catch (Exception ex) {
            this.logError("STROMANyxlet.init: " + ex, new Throwable[0]);
            throw new CycladesException(ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() throws CycladesException {
        try {
            this.destroyActionHandlers();
        }
        catch (Exception ex) {
            this.logError(ex.toString(), new Throwable[0]);
        }
        try {
            this.closeLogWriters();
        }
        catch (Exception ex) {
            this.logError(ex.toString(), new Throwable[0]);
        }
    }

    public XProperties getExternalProperties() {
        return this.externalProperties;
    }

    protected void loadExternalProperties(String path) throws Exception {
        this.loadExternalProperties(path.split("[,]"));
    }

    protected void loadExternalPropertiesDefault() throws Exception {
        String[] nyxletDirectories = STROMANyxlet.getEngineContext().getNyxletDirectories();
        String[] propertyPaths = new String[nyxletDirectories.length];
        for (int i = 0; i < nyxletDirectories.length; ++i) {
            propertyPaths[i] = nyxletDirectories[i] + "/" + this.getName() + ".properties";
        }
        this.loadExternalProperties(propertyPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExternalProperties(String[] propPaths) throws Exception {
        InputStream is = null;
        for (String propPath : propPaths) {
            try {
                is = ResourceRequestUtils.getInputStream(propPath.trim(), null);
                this.externalProperties.load(is);
                if (this.externalProperties.containsKey(SUPPLEMENTAL_PROPERTIES)) {
                    this.loadExternalProperties(STROMANyxlet.getEngineContext().getCanonicalEngineDirectoryPath((String)this.externalProperties.remove(SUPPLEMENTAL_PROPERTIES)));
                }
                this.logInfo("This external properties file was successfully loaded: " + propPath, new Throwable[0]);
                is.close();
            }
            catch (Exception ex) {
                this.logError(ex.toString(), new Throwable[0]);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public boolean auth(NyxletSession sessionDelegate, Map authAttributes, Object authMetaObject) throws Exception {
        return sessionDelegate.auth(authAttributes, authMetaObject, false) != null;
    }

    public void logDebug(String logMessage, Throwable ... t) {
        this.log(LoggingEnum.DEBUG, logMessage, t);
    }

    public void logInfo(String logMessage, Throwable ... t) {
        this.log(LoggingEnum.INFO, logMessage, t);
    }

    public void logWarn(String logMessage, Throwable ... t) {
        this.log(LoggingEnum.WARN, logMessage, t);
    }

    public void logError(String logMessage, Throwable ... t) {
        this.log(LoggingEnum.ERROR, logMessage, t);
    }

    public void logNotify(LoggingEnum level, String logMessage, Throwable ... t) {
        try {
            this.log(level, logMessage, t);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            STROMANyxlet.getEngineContext().sendNotification(level, t.length > 0 ? logMessage + " " + t[0] : logMessage);
        }
        catch (Exception e) {
            logger.log((Priority)LoggingEnum.ERROR.getLog4jLevel(), (Object)("Failed to send notification, we need to look into this: " + e));
        }
    }

    public void logStackTrace(Throwable t) {
        this.logStackTrace(t, true);
    }

    public void logStackTrace(Throwable t, boolean newLine) {
        StringBuilder sb = new StringBuilder(t.toString());
        sb.append(" > STACK_TRACE_ELEMENTS > [");
        StackTraceElement[] stes = t.getStackTrace();
        for (int i = 0; i < stes.length; ++i) {
            if (newLine) {
                sb.append("\n");
            }
            sb.append("\"").append(stes[i].toString()).append("\"");
            sb.append(i < stes.length - 1 ? "," : (newLine ? "\n" : ""));
        }
        sb.append("]");
        this.log(LoggingEnum.ERROR, sb.toString(), new Throwable[0]);
    }

    private void log(LoggingEnum loggingEnum, String message, Throwable ... t) {
        try {
            this.getLoggingDelegate(DEFAULT_LOGGING_DELEGATE).log(loggingEnum, "", t.length > 0 ? message + " " + t[0] : message);
        }
        catch (Exception e) {
            if (t.length > 0) {
                logger.log((Priority)loggingEnum.getLog4jLevel(), (Object)message, t[0]);
            }
            logger.log((Priority)loggingEnum.getLog4jLevel(), (Object)message);
        }
    }

    public boolean shouldLog(LoggingEnum logLevel) throws Exception {
        return this.shouldLog(logLevel, null);
    }

    public boolean shouldLog(LoggingEnum logLevel, LoggingEnum userLogLevel) throws Exception {
        String eLabel = "STROMANyxlet.shouldLog: ";
        try {
            LoggingDelegate loggingDelegate = this.getLoggingDelegate(DEFAULT_LOGGING_DELEGATE);
            if (loggingDelegate != null) {
                return loggingDelegate.shouldLog(logLevel, userLogLevel);
            }
            return LoggingEnum.shouldLogLog4jLevel(logger.getLevel(), logLevel.getLog4jLevel(), userLogLevel != null ? userLogLevel.getLog4jLevel() : null);
        }
        catch (Exception e) {
            throw new Exception("STROMANyxlet.shouldLog: " + e);
        }
    }

    private void processFieldValidators(List<ValidationFaultElement> validationFaultElements) throws CycladesException {
        if (validationFaultElements.size() < 1) {
            return;
        }
        throw new CycladesException(ValidationFaultElement.toString("VALIDATION_FAULT_ELEMENTS", validationFaultElements), ResponseCodeEnum.REQUEST_VALIDATION_FAULT.getCode());
    }

    @Override
    public boolean isHealthy() throws CycladesException {
        try {
            for (String key : this.actionHandlers.keySet()) {
                if (((ActionHandler)this.actionHandlers.get(key)).isHealthy()) continue;
                throw new Exception("Unhealthy action handler: " + key);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String[] listActionHandlers() {
        return this.actionHandlers.keySet().toArray(new String[0]);
    }
}

