/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class BuildNyxletManifest {
    private static boolean quiet = false;

    private static void help_and_exit() {
        System.out.println("./BuildNyxletManifiest [-q] NYXLET_FILE_NAME");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] cmd) {
        block50: {
            String derrivedAcctionHandlersDefs;
            String derrivedNyxletClassName;
            XMLReader reader;
            PickManifest manifestReader;
            byte[] nyxlet_manifest_data;
            JarFile nyxlet;
            String derrivedNyxletName;
            String nyxletFileName;
            File tempJarFile = null;
            File nyxletFile = null;
            boolean success = false;
            try {
                if (cmd == null || cmd.length == 0) {
                    BuildNyxletManifest.help_and_exit();
                }
                nyxletFileName = null;
                for (String p : cmd) {
                    if (p.equals("-q")) {
                        quiet = true;
                        continue;
                    }
                    nyxletFileName = p;
                }
                if (nyxletFileName == null) {
                    BuildNyxletManifest.help_and_exit();
                }
                if (!(nyxletFile = new File(nyxletFileName)).exists()) {
                    System.err.println("File " + nyxletFileName + " does not exist");
                    System.exit(1);
                }
                if (!nyxletFile.canRead()) {
                    System.err.println("File " + nyxletFileName + " is not readable");
                    System.exit(1);
                }
                if (!nyxletFile.canWrite()) {
                    System.err.println("File " + nyxletFileName + " is not writable");
                    System.exit(1);
                }
                String nyxletFileNameOnly = nyxletFile.getName();
                Pattern p = Pattern.compile("^([^-]+).*\\.nyxlet$");
                Matcher m = p.matcher(nyxletFileNameOnly);
                if (!m.matches()) {
                    System.err.println("File " + nyxletFileName + " is not appropriate for nyxlet.");
                    System.exit(1);
                }
                if ((derrivedNyxletName = m.group(1)) == null || derrivedNyxletName.trim().length() == 0) {
                    System.err.println("Unable to derrive nyxlet name from file name " + nyxletFileName);
                    System.exit(1);
                }
                nyxlet = new JarFile(nyxletFile);
                ZipEntry nManifest = nyxlet.getEntry("nyxlet_manifest.xml");
                nyxlet_manifest_data = null;
                InputStream in = nyxlet.getInputStream(nManifest);
                try {
                    nyxlet_manifest_data = ByteStreams.toByteArray((InputStream)in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                manifestReader = new PickManifest();
                reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                reader.setContentHandler(manifestReader);
                reader.parse(new InputSource(new ByteArrayInputStream(nyxlet_manifest_data)));
                if (manifestReader.nyxletClassName != null && manifestReader.nyxletName != null && manifestReader.actionHandlersDefs != null) {
                    if (!quiet) {
                        System.out.println("There are no modification to be applied to the nyxlet.");
                    }
                    System.exit(0);
                }
                AtomicReference<Object> derrivedNyxletClass = new AtomicReference<Object>(null);
                LinkedHashMap<String, LinkedHashMap<String, String>> aHandlers = BuildNyxletManifest.inspectNyxletFile(nyxlet, derrivedNyxletClass);
                derrivedNyxletClassName = null;
                if (manifestReader.nyxletClassName == null) {
                    derrivedNyxletClassName = derrivedNyxletClass.get();
                }
                derrivedAcctionHandlersDefs = null;
                if (manifestReader.actionHandlersDefs == null || manifestReader.actionHandlersDefs.trim().length() == 0) {
                    derrivedAcctionHandlersDefs = "";
                    for (String actionName : aHandlers.keySet()) {
                        LinkedHashMap<String, String> classesForAction = aHandlers.get(actionName);
                        if (classesForAction == null || classesForAction.size() <= 0) continue;
                        for (String classForAction : classesForAction.keySet()) {
                            derrivedAcctionHandlersDefs = derrivedAcctionHandlersDefs + (derrivedAcctionHandlersDefs.length() > 0 ? "\n" : "") + actionName + "=" + classForAction;
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block50;
            }
            if (manifestReader.nyxletClassName != null && manifestReader.nyxletName != null && manifestReader.actionHandlersDefs == null && (derrivedAcctionHandlersDefs == null || derrivedAcctionHandlersDefs.trim().length() == 0)) {
                if (!quiet) {
                    System.out.println("There are no modification to be applied to the nyxlet.");
                }
                System.exit(0);
            }
            ByteArrayOutputStream newManifest = new ByteArrayOutputStream(16384);
            ManifestXMLFilter manifestFilter = new ManifestXMLFilter(derrivedNyxletName, derrivedNyxletClassName, derrivedAcctionHandlersDefs);
            Transformer t = SAXTransformerFactory.newInstance().newTransformer();
            reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            manifestFilter.setParent(reader);
            reader = manifestFilter;
            t.transform(new SAXSource(reader, new InputSource(new ByteArrayInputStream(nyxlet_manifest_data))), new StreamResult(newManifest));
            tempJarFile = new File(nyxletFileName + ".tmp");
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            JarEntry newNyxletManifestEntry = new JarEntry("nyxlet_manifest.xml");
            tempJar.putNextEntry(newNyxletManifestEntry);
            tempJar.write(newManifest.toByteArray());
            tempJar.closeEntry();
            Enumeration<JarEntry> nyxletEntries = nyxlet.entries();
            while (nyxletEntries.hasMoreElements()) {
                JarEntry nyxletEntry = nyxletEntries.nextElement();
                if (nyxletEntry.getName().equals("nyxlet_manifest.xml")) continue;
                tempJar.putNextEntry(nyxletEntry);
                InputStream nyxletEntryIS = nyxlet.getInputStream(nyxletEntry);
                try {
                    ByteStreams.copy((InputStream)nyxletEntryIS, (OutputStream)tempJar);
                }
                finally {
                    try {
                        if (nyxletEntryIS != null) {
                            nyxletEntryIS.close();
                        }
                    }
                    catch (Exception ignore) {}
                }
                tempJar.closeEntry();
            }
            tempJar.close();
            success = true;
            if (success) {
                tempJarFile.renameTo(nyxletFile);
                if (!quiet) {
                    System.out.println("Nyxlet file has been modified.");
                }
                System.exit(0);
                break block50;
            } else {
                try {
                    if (tempJarFile != null) {
                        tempJarFile.delete();
                    }
                    break block50;
                }
                catch (Exception ignore) {}
            }
            break block50;
            finally {
                if (success) {
                    tempJarFile.renameTo(nyxletFile);
                    if (!quiet) {
                        System.out.println("Nyxlet file has been modified.");
                    }
                    System.exit(0);
                } else {
                    try {
                        if (tempJarFile != null) {
                            tempJarFile.delete();
                        }
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        System.exit(1);
    }

    private static LinkedHashMap<String, LinkedHashMap<String, String>> inspectNyxletFile(JarFile nyxletFile, AtomicReference<String> nyxletClass) throws IOException, ClassNotFoundException {
        LinkedHashMap<String, LinkedHashMap<String, String>> actionHandlers = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        Enumeration<JarEntry> e = nyxletFile.entries();
        while (e.hasMoreElements()) {
            AnnotationsAttribute visibleAnnotations;
            JarEntry entry = e.nextElement();
            String eName = entry.toString();
            if (entry.isDirectory() || !eName.endsWith(".class")) continue;
            InputStream in = nyxletFile.getInputStream(entry);
            ClassFile cf = new ClassFile(new DataInputStream(in));
            LinkedList<AnnotationsAttribute> annts = new LinkedList<AnnotationsAttribute>();
            AnnotationsAttribute invisibleAnnotations = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            if (invisibleAnnotations != null) {
                annts.push(invisibleAnnotations);
            }
            if ((visibleAnnotations = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
                annts.push(visibleAnnotations);
            }
            for (AnnotationsAttribute anntattr : annts) {
                MemberValue value;
                Annotation handlerAnnotation;
                Annotation nyxletAnnt = anntattr.getAnnotation("org.cyclades.annotations.Nyxlet");
                if (nyxletAnnt != null) {
                    nyxletClass.compareAndSet(null, cf.getName());
                }
                if ((handlerAnnotation = anntattr.getAnnotation("org.cyclades.annotations.AHandler")) == null || !((value = handlerAnnotation.getMemberValue("value")) instanceof ArrayMemberValue)) continue;
                for (MemberValue val : ((ArrayMemberValue)value).getValue()) {
                    String valueName = null;
                    if (val instanceof StringMemberValue) {
                        valueName = ((StringMemberValue)val).getValue();
                    }
                    if (valueName == null || valueName.trim().length() == 0) continue;
                    LinkedHashMap<String, String> aClasses = actionHandlers.get(val);
                    if (aClasses == null) {
                        aClasses = new LinkedHashMap();
                        actionHandlers.put(valueName.trim(), aClasses);
                    }
                    aClasses.put(cf.getName(), cf.getName());
                }
            }
        }
        return actionHandlers;
    }

    private static final class PickManifest
    extends DefaultHandler {
        private StringBuilder valueCapture = new StringBuilder();
        private Stack<String> currentXPath = new Stack();
        private boolean captureAcctionHandlersDefs = false;
        private boolean startCaptureAcctionHandlersDefs = false;
        private boolean endedCaptureAcctionHandlersDefs = false;
        public String nyxletName = null;
        public String nyxletClassName = null;
        public String actionHandlersDefs = null;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            String name = qName != null ? qName : localName;
            this.currentXPath.push(name == null ? "UKNOWN" : name);
            String cXPath = "/" + Joiner.on((String)"/").join(this.currentXPath);
            if (cXPath.equals("/manifest/nyxlet")) {
                this.nyxletName = Strings.emptyToNull((String)Strings.nullToEmpty((String)attributes.getValue("name")).trim());
                this.nyxletClassName = Strings.emptyToNull((String)Strings.nullToEmpty((String)attributes.getValue("class")).trim());
            } else if (cXPath.equals("/manifest/nyxlet/attribute")) {
                String attrName = Strings.nullToEmpty((String)attributes.getValue("name")).trim();
                if (attrName.length() > 0 && attrName.equals("actionHandlers")) {
                    this.captureAcctionHandlersDefs = true;
                }
            } else if (cXPath.equals("/manifest/nyxlet/attribute/value") && this.captureAcctionHandlersDefs && !this.endedCaptureAcctionHandlersDefs) {
                this.startCaptureAcctionHandlersDefs = true;
            }
            this.valueCapture = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            String cXPath = "/" + Joiner.on((String)"/").join(this.currentXPath);
            if (cXPath.equals("/manifest/nyxlet/attribute/value") && this.captureAcctionHandlersDefs && this.startCaptureAcctionHandlersDefs && !this.endedCaptureAcctionHandlersDefs) {
                this.endedCaptureAcctionHandlersDefs = true;
                if (this.valueCapture != null) {
                    this.actionHandlersDefs = this.valueCapture.toString().trim();
                }
            }
            this.currentXPath.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.valueCapture.append(ch, start, length);
            super.characters(ch, start, length);
        }
    }

    private static final class ManifestXMLFilter
    extends XMLFilterImpl {
        private Stack<String> currentXPath = new Stack();
        private String nyxletName;
        private String nyxletClassName;
        private String actionHandlersDefs;
        private String manifest_nyxlet_attribute_NAME = null;
        private boolean suppressChars = false;

        public ManifestXMLFilter(String nyxletName, String nyxletClassName, String actionHandlersDefs) {
            this.nyxletName = nyxletName;
            this.nyxletClassName = nyxletClassName;
            this.actionHandlersDefs = actionHandlersDefs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String name = qName != null ? qName : localName;
            this.currentXPath.push(name == null ? "UKNOWN" : name);
            String cXPath = "/" + Joiner.on((String)"/").join(this.currentXPath);
            if (cXPath.equals("/manifest/nyxlet")) {
                if (this.nyxletName != null) {
                    int nameIndex = ((AttributesImpl)(atts = new AttributesImpl(atts))).getIndex("name");
                    if (nameIndex != -1) {
                        ((AttributesImpl)atts).removeAttribute(nameIndex);
                    }
                    ((AttributesImpl)atts).addAttribute("", "name", "name", "CDATA", this.nyxletName);
                }
                if (this.nyxletClassName != null) {
                    int classIndex = ((AttributesImpl)(atts = new AttributesImpl(atts))).getIndex("class");
                    if (classIndex != -1) {
                        ((AttributesImpl)atts).removeAttribute(classIndex);
                    }
                    ((AttributesImpl)atts).addAttribute("", "class", "class", "CDATA", this.nyxletClassName);
                }
            } else if (cXPath.equals("/manifest/nyxlet/attribute")) {
                this.manifest_nyxlet_attribute_NAME = Strings.emptyToNull((String)Strings.nullToEmpty((String)atts.getValue("name")).trim());
            } else if (cXPath.equals("/manifest/nyxlet/attribute/value") && this.manifest_nyxlet_attribute_NAME != null && this.manifest_nyxlet_attribute_NAME.equals("actionHandlers") && this.actionHandlersDefs != null) {
                super.startElement(uri, localName, qName, atts);
                char[] achars = ("\n" + this.actionHandlersDefs + "\n").toCharArray();
                this.characters(achars, 0, achars.length);
                this.suppressChars = true;
                return;
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            String cXPath = "/" + Joiner.on((String)"/").join(this.currentXPath);
            if (cXPath.equals("/manifest/nyxlet/attribute/value")) {
                if (this.suppressChars) {
                    this.suppressChars = false;
                }
            } else if (cXPath.equals("/manifest/nyxlet/attribute")) {
                this.manifest_nyxlet_attribute_NAME = null;
            }
            this.currentXPath.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.suppressChars) {
                super.characters(ch, start, length);
            }
        }
    }
}

