/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.logging;

import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.cyclades.engine.logging.LogWriterInterface;

public enum LoggingEnum {
    ERROR(Level.ERROR),
    WARN(Level.WARN),
    INFO(Level.INFO),
    DEBUG(Level.DEBUG);

    private final Level log4jLevel;

    private LoggingEnum(Level log4jLevel) {
        this.log4jLevel = log4jLevel;
    }

    public void log(LoggingEnum statementUsageLoggingLevel, LogWriterInterface writer, String token, String entry) throws Exception {
        String eLabel = "LoggingEnum.log: ";
        try {
            this.log(this, statementUsageLoggingLevel, null, writer, token, entry);
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.log: " + e);
        }
    }

    public void log(LoggingEnum statementUsageLoggingLevel, LoggingEnum userUsageLoggingLevel, LogWriterInterface writer, String token, String entry) throws Exception {
        String eLabel = "LoggingEnum.log: ";
        try {
            this.log(this, statementUsageLoggingLevel, userUsageLoggingLevel, writer, token, entry);
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.log: " + e);
        }
    }

    public void log(LoggingEnum baseUsageLoggingLevel, LoggingEnum statementUsageLoggingLevel, LoggingEnum userUsageLoggingLevel, LogWriterInterface writer, String token, String entry) throws Exception {
        String eLabel = "LoggingEnum.log: ";
        try {
            if (this.shouldLog(baseUsageLoggingLevel, statementUsageLoggingLevel, userUsageLoggingLevel)) {
                StringBuilder sb = new StringBuilder("[");
                sb.append(new Date().toString());
                sb.append("] [");
                sb.append(token);
                sb.append("] ");
                sb.append(statementUsageLoggingLevel.toString());
                sb.append(" ");
                sb.append(entry);
                sb.append("\n");
                writer.write(sb.toString());
            }
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.log: " + e);
        }
    }

    public boolean shouldLog(LoggingEnum statementUsageLoggingLevel) throws Exception {
        String eLabel = "LoggingEnum.shouldLog: ";
        try {
            return this.shouldLog(this, statementUsageLoggingLevel, null);
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.shouldLog: " + e);
        }
    }

    public boolean shouldLog(LoggingEnum statementUsageLoggingLevel, LoggingEnum userUsageLoggingLevel) throws Exception {
        String eLabel = "LoggingEnum.shouldLog: ";
        try {
            return this.shouldLog(this, statementUsageLoggingLevel, userUsageLoggingLevel);
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.shouldLog: " + e);
        }
    }

    public boolean shouldLog(LoggingEnum baseUsageLoggingLevel, LoggingEnum statementUsageLoggingLevel, LoggingEnum userUsageLoggingLevel) throws Exception {
        String eLabel = "LoggingEnum.shouldLog: ";
        try {
            return userUsageLoggingLevel != null && userUsageLoggingLevel.ordinal() >= statementUsageLoggingLevel.ordinal() || statementUsageLoggingLevel.ordinal() <= baseUsageLoggingLevel.ordinal();
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.shouldLog: " + e);
        }
    }

    public static boolean shouldLogLog4jLevel(Level baseUsageLoggingLevel, Level statementUsageLoggingLevel, Level userUsageLoggingLevel) throws Exception {
        String eLabel = "LoggingEnum.shouldLogLog4jLevel: ";
        try {
            return userUsageLoggingLevel != null && statementUsageLoggingLevel.isGreaterOrEqual((Priority)userUsageLoggingLevel) || statementUsageLoggingLevel.isGreaterOrEqual((Priority)baseUsageLoggingLevel);
        }
        catch (Exception e) {
            throw new Exception("LoggingEnum.shouldLogLog4jLevel: " + e);
        }
    }

    public Level getLog4jLevel() {
        return this.log4jLevel;
    }
}

