/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.logging;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.cyclades.engine.logging.LogWriterInterface;

public class LogWriter
implements LogWriterInterface {
    private File writerFile;
    private String logToDateString;
    private String logDirectory;
    private FileWriter writer = null;
    private String logFileName;
    private SimpleDateFormat simpleDate;
    private Logger logger = null;

    public LogWriter(String logDirectory, String logFileName) throws Exception {
        String eLabel = "LogWriter.LogWriter: ";
        try {
            this.initWriter(logDirectory, logFileName, "yyyyMMdd");
        }
        catch (Exception e) {
            throw new Exception("LogWriter.LogWriter: " + e);
        }
    }

    public LogWriter(String logDirectory, String logFileName, String dateFormat) throws Exception {
        String eLabel = "LogWriter.LogWriter: ";
        try {
            this.initWriter(logDirectory, logFileName, dateFormat);
        }
        catch (Exception e) {
            throw new Exception("LogWriter.LogWriter: " + e);
        }
    }

    public void initWriter(String logDirectory, String logFileName, String dateFormat) throws Exception {
        String eLabel = "LogWriterr.initWriter: ";
        try {
            this.logDirectory = logDirectory;
            this.logFileName = logFileName;
            this.simpleDate = new SimpleDateFormat(dateFormat);
            File directory = new File(logDirectory);
            if (!directory.exists() && !directory.mkdirs()) {
                throw new Exception("Could not create directory: " + logDirectory);
            }
            this.makeLogFile(this.simpleDate.format(new Date()), true);
        }
        catch (Exception e) {
            throw new Exception("LogWriterr.initWriter: " + e);
        }
    }

    private synchronized void makeLogFile(String dateString, boolean appendToFile) throws Exception {
        String eLabel = "LogWriter.makeLogFile: ";
        try {
            this.logToDateString = dateString;
            this.writerFile = new File(this.logDirectory, this.logFileName + "." + this.logToDateString);
            if (!this.writerFile.exists() && !this.writerFile.createNewFile()) {
                throw new Exception("Failed to create data file: " + this.writerFile.getName());
            }
            this.writer = new FileWriter(this.writerFile, appendToFile);
        }
        catch (Exception e) {
            throw new Exception("LogWriter.makeLogFile: " + e);
        }
    }

    @Override
    public synchronized void write(String message) throws Exception {
        String eLabel = "LogWriter.write: ";
        try {
            this.checkAndRollNewFileIfNecessary();
            this.writer.write(message);
            this.writer.flush();
        }
        catch (Exception e) {
            throw new Exception("LogWriter.write: " + e);
        }
    }

    @Override
    public synchronized void writeLine(String message) throws Exception {
        String eLabel = "LogWriter.writeLine: ";
        try {
            this.checkAndRollNewFileIfNecessary();
            this.writer.write(message);
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (Exception e) {
            throw new Exception("LogWriter.writeLine: " + e);
        }
    }

    @Override
    public synchronized void writeDatedLine(String message, String delimeter) throws Exception {
        String eLabel = "LogWriter.writeDatedLine: ";
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(new Date().getTime());
            sb.append(delimeter);
            sb.append(message);
            sb.append("\n");
            this.checkAndRollNewFileIfNecessary();
            this.writer.write(sb.toString());
            this.writer.flush();
        }
        catch (Exception e) {
            throw new Exception("LogWriter.writeDatedLine: " + e);
        }
    }

    protected synchronized void checkAndRollNewFileIfNecessary() throws Exception {
        block4: {
            String eLabel = "LogWriter.checkAndRollNewFileIfNecessary: ";
            try {
                String currentDateString = this.simpleDate.format(new Date());
                if (currentDateString.equals(this.logToDateString)) break block4;
                try {
                    this.writer.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)("LogWriter.checkAndRollNewFileIfNecessary: " + e + "Error closing: " + this.writerFile.getName()));
                }
                this.makeLogFile(currentDateString, false);
            }
            catch (Exception e) {
                throw new Exception("LogWriter.checkAndRollNewFileIfNecessary: " + e);
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        block6: {
            String eLabel = "LogWriter.close: ";
            try {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (Exception e) {
                    if (this.logger != null) {
                        this.logger.error((Object)("LogWriter.close: " + e));
                        break block6;
                    }
                    System.out.println("LogWriter.close: " + e);
                }
            }
            catch (Exception e) {
                throw new Exception("LogWriter.close: " + e);
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

