/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine;

import java.util.List;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.cyclades.engine.util.GenericXMLObject;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.parser.api.XMLGeneratedObject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum MetaTypeEnum {
    JSON("application/json"){

        @Override
        public Object createObjectFromMeta(String meta) throws Exception {
            String eLabel = "MetaTypeEnum.createObjectFromMeta(JSON): ";
            try {
                return new JSONObject(meta);
            }
            catch (Exception e) {
                throw new Exception("MetaTypeEnum.createObjectFromMeta(JSON): " + e);
            }
        }

        @Override
        public String createMetaFromObject(Object object) throws Exception {
            String eLabel = "MetaTypeEnum.createMetaFromObject(JSON): ";
            try {
                return ((JSONObject)object).toString();
            }
            catch (Exception e) {
                throw new Exception("MetaTypeEnum.createMetaFromObject(JSON): " + e);
            }
        }

        @Override
        public Map<String, String> getMapFromMeta(Object metaObject, String[] totalParameters) throws Exception {
            return MapHelper.mapFromMeta((JSONObject)metaObject, totalParameters);
        }

        @Override
        public Map<String, List<String>> getParameterMapFromMeta(Object metaObject) throws Exception {
            return MapHelper.parameterMapFromMetaObject((JSONArray)metaObject);
        }

        @Override
        public boolean isMatch(Object object) {
            return object instanceof JSONObject;
        }

        @Override
        public String getMetaStringFromMap(Map<String, String> map) throws Exception {
            return MapHelper.mapToJSON(map, false);
        }

        @Override
        public String getMetaStringFromParameterMap(Map<String, List<String>> map) throws Exception {
            return MapHelper.parameterMapToJSON(map);
        }
    }
    ,
    XML("application/xml; charset=UTF-8"){

        @Override
        public Object createObjectFromMeta(String meta) throws Exception {
            String eLabel = "MetaTypeEnum.createObjectFromMeta(XML): ";
            try {
                return new GenericXMLObject(meta).getRootElement();
            }
            catch (Exception e) {
                throw new Exception("MetaTypeEnum.createObjectFromMeta(XML): " + e);
            }
        }

        @Override
        public String createMetaFromObject(Object object) throws Exception {
            String eLabel = "MetaTypeEnum.createMetaFromObject(JSON): ";
            try {
                return XMLGeneratedObject.toXMLString(new DOMSource((Node)object), true);
            }
            catch (Exception e) {
                throw new Exception("MetaTypeEnum.createMetaFromObject(JSON): " + e);
            }
        }

        @Override
        public Map<String, String> getMapFromMeta(Object metaObject, String[] totalParameters) throws Exception {
            return MapHelper.mapFromMeta((Node)metaObject, totalParameters);
        }

        @Override
        public Map<String, List<String>> getParameterMapFromMeta(Object metaObject) throws Exception {
            return MapHelper.parameterMapFromMetaObject((NodeList)metaObject);
        }

        @Override
        public boolean isMatch(Object object) {
            return object instanceof Node;
        }

        @Override
        public String getMetaStringFromMap(Map<String, String> map) throws Exception {
            return MapHelper.mapToXML(map, "map", false);
        }

        @Override
        public String getMetaStringFromParameterMap(Map<String, List<String>> map) throws Exception {
            return MapHelper.parameterMapToXML(map, "parameter");
        }
    };

    private String contentType;

    public abstract Object createObjectFromMeta(String var1) throws Exception;

    public abstract String createMetaFromObject(Object var1) throws Exception;

    public abstract Map<String, String> getMapFromMeta(Object var1, String[] var2) throws Exception;

    public abstract Map<String, List<String>> getParameterMapFromMeta(Object var1) throws Exception;

    public abstract String getMetaStringFromMap(Map<String, String> var1) throws Exception;

    public abstract String getMetaStringFromParameterMap(Map<String, List<String>> var1) throws Exception;

    public abstract boolean isMatch(Object var1);

    private MetaTypeEnum(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static MetaTypeEnum detectMetaTypeEnum(Object object) throws Exception {
        String eLabel = "MetaTypeEnum.detectMetaTypeEnum: ";
        try {
            if (object == null) {
                throw new Exception("null paramter value passed in");
            }
            for (MetaTypeEnum targetEnum : MetaTypeEnum.values()) {
                if (!targetEnum.isMatch(object)) continue;
                return targetEnum;
            }
            throw new Exception("No match was found for object:[" + object + "]");
        }
        catch (Exception e) {
            throw new Exception("MetaTypeEnum.detectMetaTypeEnum: " + e);
        }
    }
}

