/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.cyclades.engine.auth.api.AuthDelegate;
import org.cyclades.engine.logging.LoggingEnum;
import org.cyclades.engine.util.SendMail;
import org.json.JSONArray;
import org.json.JSONObject;

public class EngineContext {
    private final AuthDelegate authDelegate;
    private final ServletConfig servletConfig;
    private final String applicationBaseDirectory;
    private final boolean minimizeMemoryFootprint;
    private final int debugMode;
    private String[] nyxletDirectories;
    private ConcurrentHashMap<String, String[]> nyxletToTargetMap = new ConcurrentHashMap();
    private String notificationList;
    private String notificationFromEmail;
    private String notificationSMTPHost;
    private LoggingEnum notificationLevel;
    private String hostName = InetAddress.getLocalHost().getHostName();
    private final Logger notificationLogger;
    public static final String NOTIFICATION_EMAIL_DATA = "notificationEmailData";
    public static final String NOTIFICATION_LOGGER = "notificationLogger";
    public static final String DEFAULT_NOTIFICATION_LOGGER = "notify";

    public EngineContext(AuthDelegate authDelegate, ServletConfig servletConfig, String applicationBaseDirectory, boolean minimizeMemoryFootprint, int debugMode) throws Exception {
        String eLabel = "EngineContext.EngineContext: ";
        try {
            this.authDelegate = authDelegate;
            this.servletConfig = servletConfig;
            this.applicationBaseDirectory = applicationBaseDirectory;
            this.minimizeMemoryFootprint = minimizeMemoryFootprint;
            this.debugMode = debugMode;
            this.extractNotificationEmailData(servletConfig.getInitParameter(NOTIFICATION_EMAIL_DATA));
            String notificationLoggerString = servletConfig.getInitParameter(NOTIFICATION_LOGGER);
            this.notificationLogger = Logger.getLogger((String)(notificationLoggerString != null ? notificationLoggerString : DEFAULT_NOTIFICATION_LOGGER));
        }
        catch (Exception e) {
            throw new Exception("EngineContext.EngineContext: " + e);
        }
    }

    private void extractNotificationEmailData(String data) throws Exception {
        String eLabel = "EngineContext.extractNotificationEmailData: ";
        try {
            if (data == null) {
                return;
            }
            String[] dataParts = data.split("[|]");
            if (dataParts.length != 4) {
                throw new Exception("Notification email data has not been properly defined");
            }
            this.notificationList = dataParts[0].trim();
            this.notificationFromEmail = dataParts[1].trim();
            this.notificationSMTPHost = dataParts[2].trim();
            this.notificationLevel = LoggingEnum.valueOf(dataParts[3].trim().toUpperCase());
        }
        catch (Exception e) {
            throw new Exception("EngineContext.extractNotificationEmailData: " + e);
        }
    }

    public void setNyxletTargets(String nyxletRegistry) throws Exception {
        String eLabel = "EngineContext.populateNyxletTargetMap: ";
        try {
            this.nyxletToTargetMap = new ConcurrentHashMap();
            if (nyxletRegistry == null) {
                return;
            }
            JSONObject nyxletRegistryJSONObject = new JSONObject(nyxletRegistry);
            Iterator iterator = nyxletRegistryJSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                JSONArray jsonArray = nyxletRegistryJSONObject.getJSONArray(key);
                String[] targets = new String[jsonArray.length()];
                for (int i = 0; i < targets.length; ++i) {
                    targets[i] = jsonArray.getString(i);
                }
                this.nyxletToTargetMap.put(key, targets);
            }
        }
        catch (Exception e) {
            throw new Exception("EngineContext.populateNyxletTargetMap: " + e);
        }
    }

    public AuthDelegate getAuthDelegate() {
        return this.authDelegate;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getApplicatonBaseDirectory() {
        return this.applicationBaseDirectory;
    }

    public boolean isMinimizeMemoryFootprint() {
        return this.minimizeMemoryFootprint;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public String[] getNyxletDirectories() {
        return this.nyxletDirectories;
    }

    public void setNyxletDirectories(String[] nyxletDirectories) {
        this.nyxletDirectories = nyxletDirectories;
    }

    public String[] getNyxletTargets(String nyxlet) {
        return this.nyxletToTargetMap.get(nyxlet);
    }

    public void sendNotification(LoggingEnum level, String message) throws Exception {
        if (this.notificationLogger != null) {
            this.notificationLogger.log((Priority)level.getLog4jLevel(), (Object)message);
        }
        StringBuilder sb = new StringBuilder("NOTIFICATION:[");
        sb.append(this.hostName).append("] LEVEL:[").append(level.name()).append("]");
        if (this.notificationList != null && this.notificationLevel.shouldLog(level)) {
            SendMail.sendMessage(this.notificationList, this.notificationFromEmail, this.notificationSMTPHost, sb.toString(), message);
        }
    }

    public String getCanonicalEngineDirectoryPath(String path) {
        if (path.startsWith("/") || path.contains(":")) {
            return path;
        }
        return this.getCanonicalEngineApplicationBaseDirectoryPath("WEB-INF/" + path);
    }

    public String getCanonicalEngineApplicationBaseDirectoryPath(String path) {
        if (path.startsWith("/") || path.contains(":")) {
            return path;
        }
        return this.getApplicatonBaseDirectory() + "/" + path;
    }
}

