/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.collectiveutils.weightedqueue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cyclades.collectiveutils.weightedqueue.WeightedItem;
import org.cyclades.collectiveutils.weightedqueue.WeightedListEntry;

public class WeightedQueue<T> {
    private List<WeightedListEntry<T>> weightedList = new ArrayList<WeightedListEntry<T>>();
    private Double scale = new Double(0.0);

    public void add(Double weight, T item) throws Exception {
        String eLabel = "WeightedQueue.add: ";
        if (!this.weightedList.add(new WeightedListEntry<T>(weight, item))) {
            throw new Exception("WeightedQueue.add: Failed to add to list");
        }
        this.scale = this.scale + weight;
    }

    public T peek() {
        block0: while (true) {
            double probability = Math.random() * this.scale;
            Iterator<WeightedListEntry<T>> i$ = this.weightedList.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                WeightedListEntry<T> wle = i$.next();
                if (probability < wle.getWeight()) {
                    return wle.getItem();
                }
                probability -= wle.getWeight().doubleValue();
            }
            break;
        }
    }

    public T getAndRemove() {
        block0: while (true) {
            double probability = Math.random() * this.scale;
            int i = 0;
            while (true) {
                if (i >= this.weightedList.size()) continue block0;
                WeightedListEntry<T> wle = this.weightedList.get(i);
                if (probability < wle.getWeight()) {
                    this.weightedList.remove(i);
                    this.scale = this.scale - wle.getWeight();
                    return wle.getItem();
                }
                probability -= wle.getWeight().doubleValue();
                ++i;
            }
            break;
        }
    }

    public T getItemAt(int i) {
        return this.weightedList.get(i).getItem();
    }

    public int size() {
        return this.weightedList.size();
    }

    public static <T> List<WeightedItem<T>> sort(List<WeightedItem<T>> toSort) throws Exception {
        String eLabel = "WeightedQueue.sort: ";
        try {
            ArrayList<WeightedItem<T>> returnList = new ArrayList<WeightedItem<T>>();
            WeightedQueue<WeightedItem<T>> weightedQueue = new WeightedQueue<WeightedItem<T>>();
            for (WeightedItem<T> item : toSort) {
                weightedQueue.add(item.getWeight(), item);
            }
            while (weightedQueue.size() > 0) {
                returnList.add((WeightedItem<T>)weightedQueue.getAndRemove());
            }
            return returnList;
        }
        catch (Exception e) {
            throw new Exception("WeightedQueue.sort: " + e);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3 || args.length % 2 != 1) {
                System.out.println("usage: cmd num_selections [unique_name weight] ...");
                System.exit(1);
            }
            WeightedQueue<String> list = new WeightedQueue<String>();
            for (int i = 1; i < args.length; i += 2) {
                list.add(Double.parseDouble(args[i + 1]), args[i]);
            }
            HashMap<String, Integer> countHash = new HashMap<String, Integer>();
            for (int i = 0; i < Integer.parseInt(args[0]); ++i) {
                String c = (String)list.peek();
                int count = 0;
                if (countHash.containsKey(c)) {
                    count = (Integer)countHash.get(c);
                }
                countHash.put(c, ++count);
            }
            for (Map.Entry entry : countHash.entrySet()) {
                System.out.println((String)entry.getKey() + " " + entry.getValue());
            }
        }
        catch (Exception e) {
            System.out.println("Exception in main: " + e);
        }
    }
}

