/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class IncrementalLengthIterator
extends StringIterator {
    private final Supplier<StringIterator> aSupplier;
    private final int aMin;
    private final int aMax;
    private int aCurrentLength;
    private StringIterator[] aCurrentIterators;
    private String[] aGeneratedParts;

    public IncrementalLengthIterator(Supplier<StringIterator> supplier, int min, int max) {
        this.aSupplier = supplier;
        this.aMin = min;
        this.aCurrentLength = min;
        this.aMax = max;
        this.reset();
    }

    private boolean lengthCanGrow() {
        return this.aCurrentLength < this.aMax || this.aCurrentIterators.length < this.aCurrentLength || this.aMax < 0;
    }

    private boolean hasMoreForCurrentLength() {
        return Arrays.stream(this.aCurrentIterators).anyMatch(Iterator::hasNext);
    }

    @Override
    public boolean hasNext() {
        return this.lengthCanGrow() || this.hasMoreForCurrentLength();
    }

    private void extendIterators() {
        int i;
        StringIterator[] tmp = new StringIterator[this.aCurrentLength];
        for (i = 0; i < this.aCurrentIterators.length; ++i) {
            tmp[i] = this.aCurrentIterators[i];
            tmp[i].reset();
        }
        tmp[this.aCurrentLength - 1] = this.aSupplier.get();
        this.aCurrentIterators = tmp;
        this.aGeneratedParts = new String[this.aCurrentLength];
        for (i = 0; i < this.aCurrentLength; ++i) {
            this.aGeneratedParts[i] = this.aCurrentIterators[i].next();
        }
    }

    @Override
    public String nextImpl() {
        if (this.aCurrentLength == 0) {
            ++this.aCurrentLength;
            return "";
        }
        if (this.aGeneratedParts == null) {
            this.extendIterators();
        } else {
            for (int i = this.aGeneratedParts.length - 1; i >= 0; --i) {
                if (this.aCurrentIterators[i].hasNext()) {
                    this.aGeneratedParts[i] = this.aCurrentIterators[i].next();
                    break;
                }
                if (i == 0) {
                    if (this.aCurrentLength < this.aMax || this.aMax < 0) {
                        ++this.aCurrentLength;
                        this.extendIterators();
                        continue;
                    }
                    throw new NoSuchElementException("No more unique values");
                }
                this.aCurrentIterators[i].reset();
                this.aGeneratedParts[i] = this.aCurrentIterators[i].next();
            }
        }
        return Arrays.stream(this.aCurrentIterators).map(StringIterator::current).reduce("", String::concat);
    }

    @Override
    public final void reset() {
        this.aCurrentLength = this.aMin;
        this.aGeneratedParts = null;
        this.aCurrentIterators = new StringIterator[this.aCurrentLength];
        for (int i = 0; i < this.aCurrentLength; ++i) {
            this.aCurrentIterators[i] = this.aSupplier.get();
        }
    }

    @Override
    public String current() {
        return Arrays.stream(this.aCurrentIterators).map(StringIterator::current).reduce("", String::concat);
    }

    public String toString() {
        return "IncrementalLengthIterator{aSupplier=" + this.aSupplier + ", aMax=" + this.aMax + ", aCurrentLength=" + this.aCurrentLength + ", aCurrentIterators=" + Arrays.toString(this.aCurrentIterators) + ", aGeneratedParts=" + Arrays.toString(this.aGeneratedParts) + '}';
    }
}

