/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.generator.visitors.GenerationVisitor;
import com.github.curiousoddman.rgxgen.generator.visitors.GenerationVisitorBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class NotMatchingGenerationVisitor
extends GenerationVisitor {
    private static final String[] allSymbols = SymbolSet.getAllSymbols();

    public static GenerationVisitorBuilder builder() {
        return new GenerationVisitorBuilder(NotMatchingGenerationVisitor::new);
    }

    public NotMatchingGenerationVisitor(Random random, Map<Integer, String> groupValues) {
        super(random, groupValues);
    }

    @Override
    public void visit(SymbolSet node) {
        String pattern = node.getPattern();
        SymbolSet symbolSet = new SymbolSet("[^" + pattern.substring(1), node.getSymbols(), SymbolSet.TYPE.NEGATIVE);
        if (!symbolSet.isEmpty()) {
            super.visit(symbolSet);
        }
    }

    @Override
    public void visit(Choice node) {
        Node[] nodes = node.getNodes();
        int pos = this.aStringBuilder.length();
        StringBuilder groupsBuilder = new StringBuilder();
        StringBuilder valuePrefixBuilder = new StringBuilder();
        int groupValuesUsed = 0;
        int i = 1;
        while (groupValuesUsed < this.aGroupValues.size()) {
            String s = (String)this.aGroupValues.get(i);
            groupsBuilder.append('(');
            if (s != null) {
                groupsBuilder.append(Pattern.quote(s));
                ++groupValuesUsed;
            }
            groupsBuilder.append(')');
            valuePrefixBuilder.append(s);
            ++i;
        }
        Pattern pattern = Pattern.compile(groupsBuilder + node.getPattern());
        do {
            this.aStringBuilder.delete(pos, Integer.MAX_VALUE);
            int i2 = this.aRandom.nextInt(nodes.length);
            nodes[i2].visit(this);
        } while (pattern.matcher(valuePrefixBuilder + this.aStringBuilder.substring(pos)).matches());
    }

    @Override
    public void visit(FinalSymbol node) {
        String nodeValue = node.getValue();
        if (nodeValue.isEmpty()) {
            this.aStringBuilder.append(allSymbols[this.aRandom.nextInt(allSymbols.length)].charAt(0));
        } else {
            StringBuilder builder = new StringBuilder(nodeValue.length());
            do {
                builder.delete(0, Integer.MAX_VALUE);
                nodeValue.chars().map(c -> allSymbols[this.aRandom.nextInt(allSymbols.length)].charAt(0)).forEachOrdered(c -> builder.append((char)c));
            } while (nodeValue.equals(builder.toString()));
            this.aStringBuilder.append((CharSequence)builder);
        }
    }

    @Override
    public void visit(Repeat node) {
        if (node.getMin() == 0) {
            super.visit(new Repeat(node.getPattern(), node.getNode(), 1, node.getMax()));
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        DefaultTreeBuilder builder = new DefaultTreeBuilder(node.getPattern());
        Node subNode = builder.get();
        GenerationVisitor generationVisitor = new GenerationVisitor(this.aRandom, this.aGroupValues);
        subNode.visit(generationVisitor);
        this.aStringBuilder.append(generationVisitor.getString());
    }

    @Override
    public void visit(GroupRef node) {
        FinalSymbol finalSymbol = new FinalSymbol((String)this.aGroupValues.get(node.getIndex()));
        this.visit(finalSymbol);
    }
}

