/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen;

import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.visitors.GenerationVisitor;
import com.github.curiousoddman.rgxgen.generator.visitors.NotMatchingGenerationVisitor;
import com.github.curiousoddman.rgxgen.generator.visitors.UniqueGenerationVisitor;
import com.github.curiousoddman.rgxgen.generator.visitors.UniqueValuesCountingVisitor;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import java.math.BigInteger;
import java.util.Random;
import java.util.stream.Stream;

public class RgxGen {
    private final Node aNode;

    public RgxGen(String pattern) {
        this(new DefaultTreeBuilder(pattern));
    }

    public RgxGen(NodeTreeBuilder builder) {
        this.aNode = builder.get();
    }

    public BigInteger numUnique() {
        UniqueValuesCountingVisitor v = new UniqueValuesCountingVisitor();
        this.aNode.visit(v);
        return v.getCount();
    }

    public Stream<String> stream() {
        return Stream.generate(this::generate);
    }

    public StringIterator iterateUnique() {
        UniqueGenerationVisitor ugv = new UniqueGenerationVisitor();
        this.aNode.visit(ugv);
        return ugv.getUniqueStrings();
    }

    public String generate() {
        return this.generate(new Random());
    }

    public String generate(Random random) {
        GenerationVisitor gv = GenerationVisitor.builder().withRandom(random).get();
        this.aNode.visit(gv);
        return gv.getString();
    }

    public String generateNotMatching() {
        return this.generateNotMatching(new Random());
    }

    public String generateNotMatching(Random random) {
        GenerationVisitor nmgv = NotMatchingGenerationVisitor.builder().withRandom(random).get();
        this.aNode.visit(nmgv);
        return nmgv.getString();
    }
}

