/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ArrayIterator
extends StringIterator {
    private final int aMaxIndex;
    private final String[] aStrings;
    private int aIndex = -1;

    public ArrayIterator(String[] strings) {
        this.aStrings = strings;
        this.aMaxIndex = this.aStrings.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.aIndex < this.aMaxIndex;
    }

    @Override
    public String nextImpl() {
        try {
            return this.aStrings[++this.aIndex];
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new NoSuchElementException("Not enough elements in arrays");
        }
    }

    @Override
    public void reset() {
        this.aIndex = -1;
    }

    @Override
    public String current() {
        return this.aStrings[this.aIndex];
    }

    public String toString() {
        return "ArrayIterator[" + this.aIndex + "]{" + Arrays.toString(this.aStrings) + '}';
    }
}

