/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators.suppliers;

import com.github.curiousoddman.rgxgen.iterators.ReferenceIterator;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceIteratorSupplier
implements Supplier<StringIterator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceIteratorSupplier.class);
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIteratorsMap;
    private final int aIndex;

    public ReferenceIteratorSupplier(Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIteratorsMap, int index) {
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIteratorsMap = groupIteratorsMap;
        this.aIndex = index;
        LOGGER.trace("Creating idx {}\n\trefs: {}\n\tgrps: {}", new Object[]{index, referenceIteratorMap, groupIteratorsMap});
    }

    @Override
    public StringIterator get() {
        LOGGER.trace("Getting idx {}\n\trefs: {}\n\tgrps: {}", new Object[]{this.aIndex, this.aReferenceIteratorMap, this.aGroupIteratorsMap});
        ReferenceIterator referenceIterator = new ReferenceIterator();
        StringIterator stringIterator = this.aGroupIteratorsMap.get(this.aIndex);
        if (stringIterator != null) {
            LOGGER.debug("GroupRef[{}] connecting to group {} ", (Object)this.aIndex, (Object)stringIterator);
            referenceIterator.setOther(stringIterator);
        }
        LOGGER.debug("GroupRef[{}] adding to connection queue group ", (Object)this.aIndex);
        this.aReferenceIteratorMap.computeIfAbsent(this.aIndex, i -> new ArrayList()).add(referenceIterator);
        return referenceIterator;
    }

    public String toString() {
        return "ReferenceIteratorSupplier{aReferenceIteratorMap=" + this.aReferenceIteratorMap + ", aGroupIteratorsMap=" + this.aGroupIteratorsMap + ", aIndex=" + this.aIndex + '}';
    }
}

