/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PermutationsIterator
implements Iterator<String> {
    private final List<Supplier<Iterator<String>>> aIteratorsSuppliers;
    private final Iterator<String>[] aIterators;
    private final String[] aGeneratedParts;

    public PermutationsIterator(List<Supplier<Iterator<String>>> iteratorsSuppliers) {
        this.aIteratorsSuppliers = iteratorsSuppliers;
        this.aIterators = new Iterator[this.aIteratorsSuppliers.size()];
        this.aGeneratedParts = new String[this.aIterators.length];
        for (int i = 0; i < this.aIterators.length; ++i) {
            Iterator<String> iterator = this.aIteratorsSuppliers.get(i).get();
            this.aIterators[i] = iterator;
        }
        this.aGeneratedParts[0] = null;
    }

    public PermutationsIterator(int length, String[] values) {
        this(IntStream.range(0, length).mapToObj(i -> () -> Arrays.stream(values).iterator()).collect(Collectors.toList()));
    }

    @Override
    public boolean hasNext() {
        return this.aGeneratedParts[0] == null || Arrays.stream(this.aIterators).anyMatch(Iterator::hasNext);
    }

    @Override
    public String next() {
        if (this.aGeneratedParts[0] == null) {
            for (int i = 0; i < this.aGeneratedParts.length; ++i) {
                this.aGeneratedParts[i] = this.aIterators[i].next();
            }
        } else {
            for (int i = this.aGeneratedParts.length - 1; i >= 0; --i) {
                if (this.aIterators[i].hasNext()) {
                    this.aGeneratedParts[i] = this.aIterators[i].next();
                    break;
                }
                if (i == 0) {
                    throw new NoSuchElementException("No more unique values");
                }
                Iterator<String> iterator = this.aIteratorsSuppliers.get(i).get();
                this.aIterators[i] = iterator;
                this.aGeneratedParts[i] = iterator.next();
            }
        }
        return (String)Arrays.stream((Object[])this.aGeneratedParts.clone()).reduce("", String::concat);
    }

    public String toString() {
        return "PermutationsIterator{aIteratorsSuppliers=" + this.aIteratorsSuppliers + ", aIterators=" + Arrays.toString(this.aIterators) + ", aGeneratedParts=" + Arrays.toString(this.aGeneratedParts) + '}';
    }
}

