/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class IncrementalLengthIterator
implements Iterator<String> {
    private final Supplier<Iterator<String>> aSupplier;
    private final int aMax;
    private int aCurrentLength;
    private Iterator<String>[] aCurrentIterators;
    private String[] aGeneratedParts;

    public IncrementalLengthIterator(Supplier<Iterator<String>> supplier, int min, int max) {
        this.aCurrentLength = min;
        this.aSupplier = supplier;
        this.aMax = max;
    }

    private boolean lengthCanGrow() {
        return this.aCurrentLength < this.aMax || this.aMax < 0;
    }

    private boolean hasMoreForCurrentLength() {
        return this.aCurrentIterators == null || Arrays.stream(this.aCurrentIterators).anyMatch(Iterator::hasNext);
    }

    @Override
    public boolean hasNext() {
        return this.lengthCanGrow() || this.hasMoreForCurrentLength();
    }

    private void allocateNewLength() {
        this.aCurrentIterators = new Iterator[this.aCurrentLength];
        this.aGeneratedParts = new String[this.aCurrentLength];
        for (int i = 0; i < this.aCurrentLength; ++i) {
            this.aCurrentIterators[i] = this.aSupplier.get();
            this.aGeneratedParts[i] = this.aCurrentIterators[i].next();
        }
    }

    @Override
    public String next() {
        if (this.aCurrentLength == 0) {
            ++this.aCurrentLength;
            return "";
        }
        if (this.aCurrentIterators == null) {
            this.allocateNewLength();
        } else {
            for (int i = this.aGeneratedParts.length - 1; i >= 0; --i) {
                if (this.aCurrentIterators[i].hasNext()) {
                    this.aGeneratedParts[i] = this.aCurrentIterators[i].next();
                    break;
                }
                if (i == 0) {
                    if (this.aCurrentLength < this.aMax || this.aMax < 0) {
                        ++this.aCurrentLength;
                        this.allocateNewLength();
                        continue;
                    }
                    throw new NoSuchElementException("No more unique values");
                }
                Iterator<String> iterator = this.aSupplier.get();
                this.aCurrentIterators[i] = iterator;
                this.aGeneratedParts[i] = iterator.next();
            }
        }
        return (String)Arrays.stream((Object[])this.aGeneratedParts.clone()).reduce("", String::concat);
    }

    public String toString() {
        return "IncrementalLengthIterator{aSupplier=" + this.aSupplier + ", aMax=" + this.aMax + ", aCurrentLength=" + this.aCurrentLength + ", aCurrentIterators=" + Arrays.toString(this.aCurrentIterators) + ", aGeneratedParts=" + Arrays.toString(this.aGeneratedParts) + '}';
    }
}

