/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ChoiceIterator
implements Iterator<String> {
    private final List<Supplier<Iterator<String>>> aIterators;
    private Iterator<String> aCurrentIterator;

    public ChoiceIterator(List<List<Supplier<Iterator<String>>>> iterators) {
        this.aIterators = iterators.stream().flatMap(v -> v.stream()).collect(Collectors.toList());
        this.aCurrentIterator = this.aIterators.remove(0).get();
    }

    @Override
    public boolean hasNext() {
        return this.aCurrentIterator.hasNext() || !this.aIterators.isEmpty();
    }

    @Override
    public String next() {
        if (!this.aCurrentIterator.hasNext()) {
            if (this.aIterators.isEmpty()) {
                throw new NoSuchElementException("No more values");
            }
            this.aCurrentIterator = this.aIterators.remove(0).get();
        }
        return this.aCurrentIterator.next();
    }

    public String toString() {
        return "ChoiceIterator{aIterators=" + this.aIterators + ", aCurrentIterator=" + this.aCurrentIterator + '}';
    }
}

