/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.AnySymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import java.math.BigInteger;
import java.util.function.Function;

public class UniqueValuesCountingVisitor
implements NodeVisitor {
    private BigInteger aCount = BigInteger.ZERO;

    private void applyOrSkip(Function<BigInteger, BigInteger> func) {
        if (this.aCount != null) {
            this.aCount = func.apply(this.aCount);
        }
    }

    @Override
    public void visit(AnySymbol node) {
        this.applyOrSkip(v -> v.add(BigInteger.valueOf(AnySymbol.ALL_SYMBOLS.length)));
    }

    @Override
    public void visit(Choice node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(FinalSymbol node) {
        this.applyOrSkip(v -> v.add(BigInteger.ONE));
    }

    @Override
    public void visit(Repeat node) {
        UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor();
        node.getNode().visit(countingVisitor);
        if (node.getMax() < 0 || countingVisitor.aCount == null) {
            this.aCount = null;
        } else if (this.aCount != null) {
            for (int i = node.getMin(); i <= node.getMax(); ++i) {
                this.aCount = this.aCount.add(countingVisitor.aCount.pow(i));
            }
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node vnode : node.getNodes()) {
            UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor();
            vnode.visit(countingVisitor);
            this.applyOrSkip(v -> {
                if (countingVisitor.aCount == null) {
                    return null;
                }
                return v.equals(BigInteger.ZERO) ? countingVisitor.aCount : v.multiply(countingVisitor.aCount);
            });
        }
    }

    public BigInteger getCount() {
        return this.aCount;
    }
}

