/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.runner;

import cucumber.api.CucumberOptions;
import cucumber.api.StepDefinitionReporter;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.arquillian.api.Tags;
import cucumber.runtime.arquillian.api.event.AfterAfterHooks;
import cucumber.runtime.arquillian.api.event.AfterBeforeHooks;
import cucumber.runtime.arquillian.api.event.AfterStep;
import cucumber.runtime.arquillian.api.event.BeforeAfterHooks;
import cucumber.runtime.arquillian.api.event.BeforeBeforeHooks;
import cucumber.runtime.arquillian.api.event.BeforeStep;
import cucumber.runtime.arquillian.backend.ArquillianBackend;
import cucumber.runtime.arquillian.config.CucumberConfiguration;
import cucumber.runtime.arquillian.feature.Features;
import cucumber.runtime.arquillian.glue.Glues;
import cucumber.runtime.arquillian.reporter.CucumberReporter;
import cucumber.runtime.arquillian.shared.EventHelper;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.PathWithLines;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.JSONFormatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class BaseCukeSpace<CUCUMBER_REPORTER, TEST_NOTIFIER> {
    private static final Logger LOGGER = Logger.getLogger(BaseCukeSpace.class.getName());

    protected abstract Class<?> getTestedClass();

    protected abstract Exception newMultipleFailureException(List<Throwable> var1);

    protected abstract void runFeature(CucumberFeature var1, CucumberRuntime var2, CUCUMBER_REPORTER var3, TEST_NOTIFIER var4) throws Throwable;

    protected abstract CUCUMBER_REPORTER getReporter(Reporter var1, Formatter var2, RuntimeOptions var3);

    public void performInternalCucumberOperations(Object testInstance, TEST_NOTIFIER runNotifier) throws Exception {
        Class<?> javaTestClass = this.getTestedClass();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream configurationInputStream = classLoader.getResourceAsStream("cukespace-config.properties");
        Properties cukespaceConfigurationProperties = BaseCukeSpace.loadCucumberConfigurationProperties(configurationInputStream);
        RuntimeOptions runtimeOptions = BaseCukeSpace.loadRuntimeOptions(javaTestClass, cukespaceConfigurationProperties);
        boolean reported = Boolean.parseBoolean(cukespaceConfigurationProperties.getProperty("reportable", "false"));
        StringBuilder reportBuilder = new StringBuilder();
        if (reported) {
            runtimeOptions.addPlugin((Object)new JSONFormatter((Appendable)reportBuilder));
        }
        InputStream gluesInputStream = classLoader.getResourceAsStream("cukespace-glues.txt");
        Collection<Class<?>> glues = BaseCukeSpace.loadGlues(gluesInputStream, classLoader, javaTestClass);
        ArquillianBackend arquillianBackend = new ArquillianBackend(glues, javaTestClass, testInstance, cukespaceConfigurationProperties.getProperty("objectFactory"));
        CucumberRuntime cucumberRuntime = new CucumberRuntime(null, classLoader, Collections.singletonList(arquillianBackend), runtimeOptions);
        Map<String, Collection<URL>> featuresMap = Features.createFeatureMap(CucumberConfiguration.instance().getTempDir(), cukespaceConfigurationProperties.getProperty("featureHome"), javaTestClass, classLoader);
        List<CucumberFeature> cucumberFeatures = BaseCukeSpace.getCucumberFeatures(runtimeOptions.getFilters(), testInstance, classLoader, featuresMap);
        Formatter formatter = runtimeOptions.formatter(classLoader);
        Reporter reporter = runtimeOptions.reporter(classLoader);
        StepDefinitionReporter stepDefinitionReporter = runtimeOptions.stepDefinitionReporter(classLoader);
        cucumberRuntime.getGlue().reportStepDefinitions(stepDefinitionReporter);
        this.runFeatures(cucumberFeatures, cucumberRuntime, this.getReporter(reporter, formatter, runtimeOptions), runNotifier);
        if (reported) {
            String path = cukespaceConfigurationProperties.getProperty("reportablePath");
            BaseCukeSpace.addReportTestIntoFile(path, javaTestClass, reportBuilder);
        }
        this.handleCucumberTestErrors(cucumberRuntime.getErrors(), cucumberRuntime);
    }

    private static Properties loadCucumberConfigurationProperties(InputStream configurationInputStream) throws Exception {
        if (configurationInputStream != null) {
            return BaseCukeSpace.loadConfigurationPropertiesFromStream(configurationInputStream);
        }
        return BaseCukeSpace.loadConfigurationPropertiesFromObject(CucumberConfiguration.instance());
    }

    private static Properties loadConfigurationPropertiesFromStream(InputStream configurationInputStream) throws Exception {
        Properties configurationProperties = new Properties();
        configurationProperties.load(configurationInputStream);
        return configurationProperties;
    }

    private static Properties loadConfigurationPropertiesFromObject(CucumberConfiguration cucumberConfiguration) throws Exception {
        return cucumberConfiguration.getConfigurationAsProperties();
    }

    private static List<CucumberFeature> getCucumberFeatures(Collection<Object> configFilters, Object testInstance, ClassLoader classLoader, Map<String, Collection<URL>> featuresMap) throws Exception {
        ArrayList<Object> testFilters = new ArrayList<Object>(BaseCukeSpace.createFilters(testInstance, configFilters));
        InputStream featuresInputStream = classLoader.getResourceAsStream("cukespace-features.txt");
        return BaseCukeSpace.buildFeatureList(testFilters, featuresInputStream, classLoader, featuresMap);
    }

    private static List<Object> createFilters(Object testInstance, Collection<Object> configFilters) {
        CucumberOptions options;
        ArrayList<Object> filters = new ArrayList<Object>(configFilters);
        Class<?> testInstanceClass = testInstance.getClass();
        Tags tags = testInstanceClass.getAnnotation(Tags.class);
        if (tags != null) {
            filters.addAll(Collections.singletonList(tags.value()));
        }
        if ((options = testInstanceClass.getAnnotation(CucumberOptions.class)) != null) {
            if (options.tags().length > 0) {
                filters.addAll(Arrays.asList(options.tags()));
            }
            if (options.name().length > 0) {
                for (String name : options.name()) {
                    filters.add(Pattern.compile(name));
                }
            }
        }
        return filters;
    }

    private static List<CucumberFeature> buildFeatureList(List<Object> testFilters, InputStream featuresInputStream, ClassLoader classLoader, Map<String, Collection<URL>> featuresMap) throws Exception {
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>();
        FeatureBuilder featureBuilder = new FeatureBuilder(cucumberFeatures);
        if (featuresInputStream != null) {
            BaseCukeSpace.buildFeatureListFromFile(featuresInputStream, testFilters, featureBuilder, classLoader);
        } else {
            BaseCukeSpace.buildFeatureListFromMap(featuresMap, testFilters, featureBuilder);
        }
        featureBuilder.close();
        if (cucumberFeatures.isEmpty()) {
            if (featuresMap.values().isEmpty()) {
                System.out.println("Got no path to feature directory or feature file");
            } else if (testFilters.isEmpty()) {
                System.out.println(String.format("No features found at %s", featuresMap.values()));
            } else {
                System.out.println(String.format("None of the features at %s matched the filters: %s", featuresMap.values(), testFilters));
            }
        }
        Collections.sort(cucumberFeatures, new Comparator<CucumberFeature>(){

            @Override
            public int compare(CucumberFeature o1, CucumberFeature o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return cucumberFeatures;
    }

    private static void buildFeatureListFromFile(InputStream featuresInputStream, List<Object> testFilters, FeatureBuilder featureBuilder, ClassLoader classLoader) throws Exception {
        String readerLine;
        BufferedReader featuresFileReader = new BufferedReader(new InputStreamReader(featuresInputStream));
        while ((readerLine = featuresFileReader.readLine()) != null) {
            if ((readerLine = readerLine.trim()).isEmpty()) continue;
            PathWithLines pathWithLines = new PathWithLines(readerLine);
            testFilters.addAll(pathWithLines.lines);
            featureBuilder.parse((Resource)new ClassLoaderResource(classLoader, pathWithLines.path), new ArrayList<Object>(testFilters));
        }
        featuresFileReader.close();
    }

    private static void buildFeatureListFromMap(Map<String, Collection<URL>> featuresMap, List<Object> testFilters, FeatureBuilder featureBuilder) {
        for (Map.Entry<String, Collection<URL>> entry : featuresMap.entrySet()) {
            PathWithLines pathWithLines = new PathWithLines(entry.getKey());
            testFilters.addAll(pathWithLines.lines);
            for (URL url : entry.getValue()) {
                featureBuilder.parse((Resource)new URLResource(pathWithLines.path, url), new ArrayList<Object>(testFilters));
            }
        }
    }

    private static RuntimeOptions loadRuntimeOptions(Class<?> javaTestClass, Properties cukespaceConfigurationProperties) {
        RuntimeOptions runtimeOptions;
        if (javaTestClass.getAnnotation(CucumberOptions.class) != null) {
            RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(javaTestClass);
            runtimeOptions = runtimeOptionsFactory.create();
            BaseCukeSpace.cleanClasspathList(runtimeOptions.getGlue());
            BaseCukeSpace.cleanClasspathList(runtimeOptions.getFeaturePaths());
        } else {
            runtimeOptions = cukespaceConfigurationProperties.containsKey("options") ? new RuntimeOptions(new Env("cucumber-jvm"), Arrays.asList((cukespaceConfigurationProperties.getProperty("options", "--strict") + " --strict").split(" "))) : new RuntimeOptions(new Env("cucumber-jvm"), Arrays.asList("--strict", "--plugin", "pretty", BaseCukeSpace.areColorsNotAvailable(cukespaceConfigurationProperties)));
        }
        return runtimeOptions;
    }

    private static void cleanClasspathList(List<String> list) {
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("classpath:")) continue;
            it.remove();
        }
    }

    private static Collection<Class<?>> loadGlues(InputStream gluesInputStream, ClassLoader classLoader, Class<?> javaTestClass) throws Exception {
        LinkedList glues = new LinkedList();
        if (gluesInputStream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(gluesInputStream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                glues.add(classLoader.loadClass(line));
            }
            reader.close();
        } else {
            glues.addAll(Glues.findGlues(javaTestClass));
        }
        return glues;
    }

    private void runFeatures(List<CucumberFeature> cucumberFeatures, CucumberRuntime cucumberRuntime, CUCUMBER_REPORTER reporter, TEST_NOTIFIER runNotifier) throws Exception {
        for (CucumberFeature feature : cucumberFeatures) {
            LOGGER.info("Running " + feature.getPath());
            try {
                this.runFeature(feature, cucumberRuntime, reporter, runNotifier);
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
        }
        if (Formatter.class.isInstance(reporter)) {
            Formatter f = (Formatter)Formatter.class.cast(reporter);
            f.done();
            f.close();
        }
        cucumberRuntime.printSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReportTestIntoFile(String path, Class<?> javaTestClass, StringBuilder reportBuilder) throws Exception {
        if (path != null) {
            File destination = CucumberConfiguration.reportFile(path, javaTestClass);
            File parentFile = destination.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IllegalArgumentException("Can't create " + parentFile.getAbsolutePath());
            }
            try (FileWriter writer = null;){
                writer = new FileWriter(destination);
                writer.write(reportBuilder.toString());
                writer.flush();
            }
            CucumberReporter.addReport(CucumberConfiguration.reportFile(path, javaTestClass));
        }
    }

    public void handleCucumberTestErrors(List<Throwable> errors, CucumberRuntime cucumberRuntime) throws Exception {
        for (String snippet : cucumberRuntime.getSnippets()) {
            errors.add((Throwable)new CucumberException("Missing snippet: " + snippet));
        }
        if (!errors.isEmpty()) {
            throw this.newMultipleFailureException(errors);
        }
    }

    private static String areColorsNotAvailable(Properties cukespaceConfig) {
        if (!Boolean.parseBoolean(cukespaceConfig.getProperty("colors", "false"))) {
            return "--monochrome";
        }
        return "--no-monochrome";
    }

    public static class CucumberRuntime
    extends Runtime {
        public CucumberRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
            super(resourceLoader, classLoader, backends, runtimeOptions);
        }

        public void runStep(final String featurePath, final Step step, final Reporter reporter, I18n i18n) {
            super.runStep(featurePath, step, new Reporter(){

                public void match(Match match) {
                    if (StepDefinitionMatch.class.isInstance(match)) {
                        EventHelper.matched((StepDefinitionMatch)StepDefinitionMatch.class.cast(match));
                        EventHelper.fire((Object)new BeforeStep(featurePath, step));
                    }
                    reporter.match(match);
                }

                public void before(Match match, Result result) {
                    reporter.before(match, result);
                }

                public void result(Result result) {
                    reporter.result(result);
                }

                public void after(Match match, Result result) {
                    reporter.after(match, result);
                    if (StepDefinitionMatch.class.isInstance(match)) {
                        EventHelper.fire((Object)new AfterStep(featurePath, step));
                        EventHelper.unmatch();
                    }
                }

                public void embedding(String mimeType, byte[] data) {
                    reporter.embedding(mimeType, data);
                }

                public void write(String text) {
                    reporter.write(text);
                }
            }, i18n);
        }

        public void runBeforeHooks(Reporter reporter, Set<Tag> tags) {
            EventHelper.fire(new BeforeBeforeHooks());
            super.runBeforeHooks(reporter, tags);
            EventHelper.fire(new AfterBeforeHooks());
        }

        public void runAfterHooks(Reporter reporter, Set<Tag> tags) {
            EventHelper.fire(new BeforeAfterHooks());
            super.runAfterHooks(reporter, tags);
            EventHelper.fire(new AfterAfterHooks());
        }
    }

    private static class URLResource
    implements Resource {
        private final URL url;
        private final String path;

        public URLResource(String path, URL url) {
            this.url = url;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getAbsolutePath() {
            return this.url.toExternalForm();
        }

        public InputStream getInputStream() throws IOException {
            return this.url.openStream();
        }

        public String getClassName(String extension) {
            String path = this.getPath();
            return path.substring(0, path.length() - extension.length()).replace('/', '.');
        }
    }

    private static class ClassLoaderResource
    implements Resource {
        private final String path;
        private final ClassLoader loader;

        public ClassLoaderResource(ClassLoader loader, String path) {
            this.path = path;
            this.loader = loader;
        }

        public String getPath() {
            return this.path;
        }

        public String getAbsolutePath() {
            URL resource = this.loader.getResource(this.path);
            if (resource == null) {
                throw new IllegalArgumentException(this.path + " doesn't exist");
            }
            return resource.toExternalForm();
        }

        public InputStream getInputStream() throws IOException {
            URL resource = this.loader.getResource(this.path);
            if (resource == null) {
                throw new IllegalArgumentException(this.path + " doesn't exist");
            }
            return resource.openStream();
        }

        public String getClassName(String extension) {
            String path = this.getPath();
            return path.substring(0, path.length() - extension.length()).replace('/', '.');
        }
    }
}

