/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.lifecycle;

import cucumber.api.java.en.And;
import cucumber.api.java.en.But;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import cucumber.runtime.arquillian.stream.NotCloseablePrintStream;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class CucumberLifecycle {
    private static final PrintStream ORIGINAL_OUT = System.out;
    private static final PrintStream NOT_CLOSEABLE_OUT = new NotCloseablePrintStream(ORIGINAL_OUT);
    private static final Collection<Class<? extends Annotation>> CUCUMBER_ANNOTATIONS = new ArrayList<Class<? extends Annotation>>();
    private static final Collection<TestEnricher> TEST_ENRICHERS = new ArrayList<TestEnricher>();
    private static volatile Collection<ResourceLoader> RESOURCES_LOADERS = null;
    @Inject
    private Instance<org.jboss.arquillian.core.spi.ServiceLoader> serviceLoader;

    public void init(@Observes BeforeClass beforeClass) {
        System.setOut(NOT_CLOSEABLE_OUT);
    }

    public void reset(@Observes AfterClass afterClass) {
        System.setOut(ORIGINAL_OUT);
        CUCUMBER_ANNOTATIONS.clear();
        TEST_ENRICHERS.clear();
        RESOURCES_LOADERS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCucumberAnnotationsAndEnrichers(@Observes(precedence=1) Before before) {
        TEST_ENRICHERS.clear();
        Object object = TEST_ENRICHERS;
        synchronized (object) {
            if (TEST_ENRICHERS.isEmpty()) {
                TEST_ENRICHERS.addAll(((org.jboss.arquillian.core.spi.ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class));
            }
        }
        if (CUCUMBER_ANNOTATIONS.isEmpty()) {
            object = CUCUMBER_ANNOTATIONS;
            synchronized (object) {
                ClassLoader tccl;
                InputStream is;
                if (CUCUMBER_ANNOTATIONS.isEmpty() && (is = (tccl = Thread.currentThread().getContextClassLoader()).getResourceAsStream("cukespace-annotations.txt")) != null) {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            try {
                                CUCUMBER_ANNOTATIONS.add(tccl.loadClass(line));
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (RESOURCES_LOADERS == null) {
            object = this;
            synchronized (object) {
                if (RESOURCES_LOADERS == null) {
                    RESOURCES_LOADERS = new ArrayList<ResourceLoader>();
                    RESOURCES_LOADERS.addAll(((org.jboss.arquillian.core.spi.ServiceLoader)this.serviceLoader.get()).all(ResourceLoader.class));
                    for (ResourceLoader l : ServiceLoader.load(ResourceLoader.class)) {
                        RESOURCES_LOADERS.add(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Class<? extends Annotation>> cucumberAnnotations() {
        if (!CUCUMBER_ANNOTATIONS.isEmpty()) {
            return CUCUMBER_ANNOTATIONS;
        }
        Collection<Class<? extends Annotation>> collection = CUCUMBER_ANNOTATIONS;
        synchronized (collection) {
            if (!CUCUMBER_ANNOTATIONS.isEmpty()) {
                return CUCUMBER_ANNOTATIONS;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ResourceLoaderClassFinder finder = new ResourceLoaderClassFinder((ResourceLoader)new MultiLoader(loader), loader);
            CUCUMBER_ANNOTATIONS.addAll(finder.getDescendants(Annotation.class, "cucumber.api"));
            if (CUCUMBER_ANNOTATIONS.isEmpty()) {
                return Arrays.asList(Given.class, When.class, Then.class, And.class, But.class);
            }
            return CUCUMBER_ANNOTATIONS;
        }
    }

    public static Object enrich(Object instance) {
        for (TestEnricher enricher : TEST_ENRICHERS) {
            try {
                enricher.enrich(instance);
            }
            catch (Exception exception) {}
        }
        return instance;
    }

    public static Collection<ResourceLoader> resourceLoaders() {
        if (RESOURCES_LOADERS == null) {
            return Collections.emptyList();
        }
        return RESOURCES_LOADERS;
    }
}

