/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.backend;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.ObjectFactory;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.arquillian.api.Lambda;
import cucumber.runtime.arquillian.backend.ArquillianHookDefinition;
import cucumber.runtime.arquillian.backend.ArquillianSnippet;
import cucumber.runtime.arquillian.backend.ArquillianStepDefinition;
import cucumber.runtime.arquillian.container.ContextualObjectFactoryBase;
import cucumber.runtime.arquillian.container.CukeSpaceCDIObjectFactory;
import cucumber.runtime.arquillian.lifecycle.CucumberLifecycle;
import cucumber.runtime.arquillian.shared.ClassLoaders;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ArquillianBackend
extends JavaBackend
implements Backend {
    private SnippetGenerator snippetGenerator;
    private final Collection<Class<?>> glues = new ArrayList();
    private Glue glue;
    private GlueType glueType = GlueType.UNKNOWN;
    private ObjectFactory objectFactory = this.defaultObjectFactory(null, null);
    private Class<?> testClass;

    public ArquillianBackend() {
        super(null, new ClassFinder(){
            private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

            public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, String packageName) {
                return Collections.emptyList();
            }

            public <T> Class<? extends T> loadClass(String s) throws ClassNotFoundException {
                return this.loader.loadClass(s);
            }
        });
    }

    public ArquillianBackend(Collection<Class<?>> classes, Class<?> clazz, Object testInstance, String objectFactory) {
        this();
        this.glues.addAll(classes);
        this.testClass = clazz;
        try {
            this.objectFactory = objectFactory == null ? this.defaultObjectFactory(clazz, testInstance) : this.wrapObjectFactory(clazz, testInstance, "cdi".equalsIgnoreCase(objectFactory.trim()) ? new CukeSpaceCDIObjectFactory() : (ObjectFactory)ObjectFactory.class.cast(Thread.currentThread().getContextClassLoader().loadClass(objectFactory.trim()).getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private ObjectFactory wrapObjectFactory(final Class<?> clazz, final Object testInstance, final ObjectFactory cast) {
        return new ObjectFactory(){

            public void start() {
                cast.start();
            }

            public void stop() {
                cast.stop();
            }

            public boolean addClass(Class<?> glueClass) {
                return glueClass == clazz || cast.addClass(glueClass);
            }

            public <T> T getInstance(Class<T> glueClass) {
                return (T)(glueClass == clazz ? glueClass.cast(testInstance) : cast.getInstance(glueClass));
            }
        };
    }

    private ObjectFactory defaultObjectFactory(final Class<?> clazz, final Object testInstance) {
        return new ContextualObjectFactoryBase(){
            private final Map<Class<?>, Object> instances = new HashMap();
            {
                this.instances.put(clazz, testInstance);
            }

            @Override
            public void stop() {
                this.instances.clear();
            }

            @Override
            public boolean addClass(Class<?> clazz2) {
                return this.getInstance(clazz2) != null;
            }

            public <T> T getInstance(Class<T> type) {
                T instance = type.cast(this.instances.get(type));
                if (instance == null) {
                    try {
                        Constructor<T> constructor = type.getConstructor(new Class[0]);
                        instance = constructor.newInstance(new Object[0]);
                        this.instances.put(type, instance);
                        return instance;
                    }
                    catch (Exception e) {
                        throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
                    }
                }
                return instance;
            }
        };
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        super.loadGlue(glue, Collections.emptyList());
        this.glue = glue;
        this.scan();
    }

    private void initInstances() {
        for (Class<?> glueClass : this.glues) {
            try {
                this.initLambda(CucumberLifecycle.enrich(this.objectFactory.getInstance(glueClass)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't instantiate " + glueClass.getName(), e);
            }
        }
        if (this.testClass != null) {
            this.initLambda(CucumberLifecycle.enrich(this.objectFactory.getInstance(this.testClass)));
        }
    }

    private void initLambda(Object instance) {
        this.beforeCreate();
        try {
            if (Lambda.class.isInstance(instance)) {
                ((Lambda)Lambda.class.cast(instance)).define();
            }
        }
        finally {
            this.afterCreate();
        }
    }

    private void scan() {
        for (Collection list : Arrays.asList(this.glues, Collections.singletonList(this.testClass))) {
            for (Class clazz : list) {
                if (clazz == null) continue;
                if (this.readFromJava(clazz)) {
                    this.glueType = GlueType.JAVA;
                }
                if (!this.readFromScalaDsl(this.objectFactory.getInstance(clazz)) || this.glueType == GlueType.JAVA) continue;
                this.glueType = GlueType.SCALA;
            }
            if (this.glueType == GlueType.UNKNOWN) continue;
            break;
        }
    }

    private boolean readFromJava(Class<?> clazz) {
        boolean found = false;
        for (Method method : clazz.getMethods()) {
            for (Class<? extends Annotation> cucumberAnnotationClass : CucumberLifecycle.cucumberAnnotations()) {
                Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
                if (annotation == null) continue;
                if (this.isHookAnnotation(annotation)) {
                    this.addHook(annotation, method, this.objectFactory.getInstance(clazz));
                    found = true;
                    continue;
                }
                if (!this.isStepdefAnnotation(annotation)) continue;
                this.addStepDefinition(annotation, method, this.objectFactory.getInstance(clazz));
                found = true;
            }
        }
        return found;
    }

    private boolean readFromScalaDsl(Object instance) {
        try {
            ClassLoaders.load("cucumber.api.scala.ScalaDsl");
            Class<?> clazz = instance.getClass();
            Collection<StepDefinition> stepDefinitions = ArquillianBackend.readField(clazz, "stepDefinitions", instance, StepDefinition.class);
            for (StepDefinition stepDefinition : stepDefinitions) {
                this.glue.addStepDefinition((StepDefinition)StepDefinition.class.cast(stepDefinition));
            }
            Collection<HookDefinition> beforeHooks = ArquillianBackend.readField(clazz, "beforeHooks", instance, HookDefinition.class);
            for (HookDefinition sd : beforeHooks) {
                this.glue.addBeforeHook((HookDefinition)HookDefinition.class.cast(sd));
            }
            Collection<HookDefinition> collection = ArquillianBackend.readField(clazz, "afterHooks", instance, HookDefinition.class);
            for (HookDefinition sd : collection) {
                this.glue.addAfterHook((HookDefinition)HookDefinition.class.cast(sd));
            }
            return stepDefinitions.size() + beforeHooks.size() + collection.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }

    private void addStepDefinition(Annotation annotation, Method method, Object instance) {
        try {
            this.glue.addStepDefinition((StepDefinition)new ArquillianStepDefinition(method, this.pattern(annotation), this.timeout(annotation), instance));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeout(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }

    private void addHook(Annotation annotation, Method method, Object instance) {
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            long timeout = ((Before)annotation).timeout();
            this.glue.addBeforeHook((HookDefinition)new ArquillianHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, instance));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            long timeout = ((After)annotation).timeout();
            this.glue.addAfterHook((HookDefinition)new ArquillianHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, instance));
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void beforeCreate() {
        INSTANCE.set(this);
    }

    public void afterCreate() {
        INSTANCE.remove();
    }

    public void buildWorld() {
        this.objectFactory.start();
        this.initInstances();
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public String getSnippet(Step step, FunctionNameGenerator nameGenerator) {
        if (this.snippetGenerator == null && GlueType.SCALA.equals((Object)this.glueType)) {
            try {
                this.snippetGenerator = new SnippetGenerator((Snippet)Snippet.class.cast(ClassLoaders.load("cucumber.runtime.scala.ScalaSnippetGenerator").newInstance()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.snippetGenerator == null) {
            this.snippetGenerator = new SnippetGenerator((Snippet)new ArquillianSnippet());
        }
        return this.snippetGenerator.getSnippet(step, nameGenerator);
    }

    private static <T> Collection<T> readField(Class<?> clazz, String field, Object instance, Class<T> cast) throws Exception {
        Field f = clazz.getDeclaredField(field);
        f.setAccessible(true);
        Object o = f.get(instance);
        Class<?> arrayBuffer = ClassLoaders.load("scala.collection.mutable.ArrayBuffer");
        if (arrayBuffer.isInstance(o)) {
            Object[] array = (Object[])Object[].class.cast(arrayBuffer.getDeclaredMethod("array", new Class[0]).invoke(o, new Object[0]));
            ArrayList<T> result = new ArrayList<T>(array.length);
            for (Object i : array) {
                if (!cast.isInstance(i)) continue;
                result.add(cast.cast(i));
            }
            return result;
        }
        throw new IllegalArgumentException("expected an ArrayBuffer and got " + o);
    }

    protected static enum GlueType {
        JAVA,
        SCALA,
        UNKNOWN;

    }
}

