/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.client;

import cucumber.api.junit.Cucumber;
import cucumber.deps.com.thoughtworks.xstream.converters.ConverterRegistry;
import cucumber.runtime.arquillian.ArquillianCucumber;
import cucumber.runtime.arquillian.CukeSpace;
import cucumber.runtime.arquillian.api.event.StepEvent;
import cucumber.runtime.arquillian.backend.ArquillianBackend;
import cucumber.runtime.arquillian.config.CucumberConfiguration;
import cucumber.runtime.arquillian.container.CucumberContainerExtension;
import cucumber.runtime.arquillian.feature.Features;
import cucumber.runtime.arquillian.glue.Glues;
import cucumber.runtime.arquillian.lifecycle.CucumberLifecycle;
import cucumber.runtime.arquillian.locator.JarLocation;
import cucumber.runtime.arquillian.reporter.CucumberReporter;
import cucumber.runtime.arquillian.shared.ClassLoaders;
import cucumber.runtime.arquillian.shared.ClientServerFiles;
import cucumber.runtime.arquillian.shared.IOs;
import cucumber.runtime.arquillian.stream.NotCloseablePrintStream;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.JavaBackend;
import gherkin.util.Mapper;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths;
import org.junit.runner.RunWith;

public class CucumberArchiveProcessor
implements ApplicationArchiveProcessor {
    private static volatile StringAsset scannedAnnotations = null;
    @Inject
    private Instance<CucumberConfiguration> configuration;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return;
        }
        Class javaClass = testClass.getJavaClass();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Map<String, Collection<URL>> featureUrls = Features.createFeatureMap(((CucumberConfiguration)this.configuration.get()).getTempDir(), ((CucumberConfiguration)this.configuration.get()).getFeatureHome(), javaClass, loader);
        if (featureUrls.isEmpty() || !LibraryContainer.class.isInstance(applicationArchive)) {
            RunWith runWith = (RunWith)testClass.getAnnotation(RunWith.class);
            if (runWith == null || !ArquillianCucumber.class.equals((Object)runWith.value()) && !CukeSpace.class.equals((Object)runWith.value())) {
                return;
            }
            Logger.getLogger(CucumberArchiveProcessor.class.getName()).info("No feature found for " + javaClass.getName());
        }
        String ln = System.getProperty("line.separator");
        LibraryContainer libraryContainer = (LibraryContainer)applicationArchive;
        JavaArchive resourceJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cukespace-resources.jar");
        CucumberConfiguration cucumberConfiguration = (CucumberConfiguration)this.configuration.get();
        boolean report = cucumberConfiguration.isReport() || cucumberConfiguration.isGenerateDocs();
        String reportDirectory = cucumberConfiguration.getReportDirectory();
        CucumberArchiveProcessor.addFeatures(featureUrls, ln, resourceJar);
        CucumberArchiveProcessor.addCucumberAnnotations(ln, resourceJar);
        CucumberArchiveProcessor.addConfiguration(resourceJar, cucumberConfiguration, report, reportDirectory);
        libraryContainer.addAsLibrary((Archive)resourceJar);
        if (report) {
            CucumberReporter.addReport(CucumberConfiguration.reportFile(reportDirectory, javaClass));
        }
        CucumberArchiveProcessor.enrichWithGlues(javaClass, libraryContainer, ln);
        CucumberArchiveProcessor.enrichWithDefaultCucumber(libraryContainer);
        CucumberArchiveProcessor.enrichWithCukeSpace(libraryContainer);
        Set<ArchivePath> libs = applicationArchive.getContent((Filter)new IncludeRegExpPaths("/WEB-INF/lib/.*jar")).keySet();
        CucumberArchiveProcessor.tryToAdd(libs, libraryContainer, "WEB-INF/lib/scala-library-", "cucumber.api.scala.ScalaDsl", "scala.App");
    }

    private static void addConfiguration(JavaArchive resourceJar, CucumberConfiguration cucumberConfiguration, boolean report, String reportDirectory) {
        StringBuilder config = new StringBuilder();
        config.append("colors").append("=").append(cucumberConfiguration.isColorized()).append("\n").append("reportable").append("=").append(report).append("\n").append("reportablePath").append("=").append(reportDirectory).append("\n");
        if (cucumberConfiguration.hasOptions()) {
            config.append("options").append("=").append(cucumberConfiguration.getOptions());
        }
        resourceJar.addAsResource((Asset)new StringAsset(config.toString()), "cukespace-config.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void addCucumberAnnotations(String ln, JavaArchive resourceJar) {
        if (scannedAnnotations == null) {
            Class<CucumberArchiveProcessor> clazz = CucumberArchiveProcessor.class;
            // MONITORENTER : cucumber.runtime.arquillian.client.CucumberArchiveProcessor.class
            if (scannedAnnotations == null) {
                StringBuilder builder = new StringBuilder();
                for (Class<? extends Annotation> annotation : CucumberLifecycle.cucumberAnnotations()) {
                    builder.append(annotation.getName()).append(ln);
                }
                scannedAnnotations = new StringAsset(builder.toString());
            }
            // MONITOREXIT : clazz
        }
        resourceJar.addAsResource((Asset)scannedAnnotations, "cukespace-annotations.txt");
    }

    private static void addFeatures(Map<String, Collection<URL>> featureUrls, String ln, JavaArchive resourceJar) {
        StringBuilder featuresPaths = new StringBuilder();
        for (Map.Entry<String, Collection<URL>> feature : featureUrls.entrySet()) {
            Collection<URL> features = feature.getValue();
            int size = features.size();
            if (size == 0) continue;
            String key = feature.getKey();
            if (size == 1) {
                StringAsset featureAsset = new StringAsset(new String(IOs.slurp(features.iterator().next())));
                resourceJar.addAsResource((Asset)featureAsset, key);
                featuresPaths.append(key).append(ln);
                continue;
            }
            for (URL url : features) {
                StringAsset featureAsset = new StringAsset(new String(IOs.slurp(url)));
                String target = key + CucumberArchiveProcessor.featureName(url);
                resourceJar.addAsResource((Asset)featureAsset, target);
                featuresPaths.append(target).append(ln);
            }
        }
        resourceJar.addAsResource((Asset)new StringAsset(featuresPaths.toString()), "cukespace-features.txt");
    }

    private static void enrichWithDefaultCucumber(LibraryContainer<?> libraryContainer) {
        libraryContainer.addAsLibraries(new File[]{JarLocation.jarLocation(Mapper.class), JarLocation.jarLocation(ResourceLoaderClassFinder.class), JarLocation.jarLocation(ConverterRegistry.class), JarLocation.jarLocation(JavaBackend.class), JarLocation.jarLocation(Cucumber.class)});
        try {
            File j8 = JarLocation.jarLocation(Thread.currentThread().getContextClassLoader().loadClass("cucumber.runtime.java8.LambdaGlueBase"));
            libraryContainer.addAsLibraries(new File[]{j8});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void enrichWithGlues(Class<?> javaClass, LibraryContainer<?> libraryContainer, String ln) {
        Collection<Class<?>> glues = Glues.findGlues(javaClass);
        StringBuilder gluesStr = new StringBuilder();
        if (!glues.isEmpty()) {
            JavaArchive gluesJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cukespace-glues.jar");
            for (Class<?> g : glues) {
                gluesStr.append(g.getName()).append(ln);
            }
            gluesJar.add((Asset)new StringAsset(gluesStr.toString()), "cukespace-glues.txt");
            gluesJar.addClasses(glues.toArray(new Class[glues.size()]));
            for (Class<?> clazz : glues) {
                Class<?> current = clazz.getSuperclass();
                while (!Object.class.equals(current)) {
                    if (!gluesJar.contains(AssetUtil.getFullPathForClassResource(current))) {
                        gluesJar.addClass(current);
                    }
                    current = current.getSuperclass();
                }
            }
            libraryContainer.addAsLibrary((Archive)gluesJar);
        }
    }

    private static void enrichWithCukeSpace(LibraryContainer<?> libraryContainer) {
        libraryContainer.addAsLibrary(((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cukespace-core.jar")).addAsServiceProvider(RemoteLoadableExtension.class, new Class[]{CucumberContainerExtension.class})).addPackage(ArquillianBackend.class.getPackage())).addPackage(cucumber.runtime.arquillian.api.Glues.class.getPackage())).addPackage(StepEvent.class.getPackage())).addClass(NotCloseablePrintStream.class)).addClass(CucumberReporter.class)).addClass(CucumberLifecycle.class)).addClass(Features.class)).addClass(Glues.class)).addClass(CucumberConfiguration.class)).addClasses(new Class[]{ArquillianCucumber.class, CukeSpace.class})).addPackage(ClientServerFiles.class.getPackage())).addClass(CucumberContainerExtension.class));
    }

    private static void tryToAdd(Collection<ArchivePath> paths, LibraryContainer<?> container, String exclusion, String ... classes) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            for (String clazz : classes) {
                File file = JarLocation.jarLocation(ClassLoaders.load(clazz));
                boolean found = false;
                for (ArchivePath ap : paths) {
                    String path = ap.get();
                    if (!path.contains(exclusion) || !path.endsWith(".jar")) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                files.add(file);
            }
        }
        catch (Exception e) {
            return;
        }
        container.addAsLibraries(files.toArray(new File[files.size()]));
    }

    private static String featureName(URL url) {
        File f = new File(url.getFile());
        if (f.exists()) {
            return f.getName();
        }
        String path = url.getPath();
        if (path.lastIndexOf("!") < path.lastIndexOf("/")) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        return Math.abs(url.hashCode()) + ".feature";
    }
}

