/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.backend;

import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;

public class ArquillianStepDefinition
implements StepDefinition {
    private final Method method;
    private final Pattern pattern;
    private final long timeout;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final Object instance;
    private List<ParameterInfo> parameterInfos;

    public ArquillianStepDefinition(Method method, Pattern pattern, long timeout, Object instance) {
        this.method = method;
        this.parameterInfos = ParameterInfo.fromMethod((Method)method);
        this.pattern = pattern;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.timeout = timeout;
        this.instance = instance;
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        Utils.invoke((Object)this.instance, (Method)this.method, (long)this.timeout, (Object[])args);
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) {
        return this.parameterInfos.get(n);
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return false;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Method getMethod() {
        return this.method;
    }
}

