/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

public class FileUtil {
    public static Logger log = Logger.getLogger(FileUtil.class.getName());
    public static final Pattern ADOC_FILE_EXTENSION = Pattern.compile("([^\\s]+(\\.(?i)(ad|adoc|asciidoc|asc))$)");

    public static String findJsonFile(String path) {
        File f;
        if (path == null) {
            path = "";
        }
        if ((f = new File(path)).exists()) {
            return f.getAbsolutePath();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Paths.get(path.trim(), new String[0]).toAbsolutePath().toString();
    }

    public static List<String> findJsonFiles(String startDir) {
        if (startDir == null) {
            startDir = "";
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(new String[]{"**/*.json"});
        File f = new File(startDir);
        if (f.exists()) {
            startDir = f.getAbsolutePath();
            scanner.setBasedir(startDir);
        } else {
            if (startDir.startsWith("/")) {
                startDir = startDir.substring(1);
            }
            scanner.setBasedir(new File(Paths.get(startDir.trim(), new String[0]).toAbsolutePath().toString()));
        }
        scanner.scan();
        ArrayList<String> absolutePaths = new ArrayList<String>(scanner.getIncludedFiles().length);
        for (int i = 0; i < scanner.getIncludedFiles().length; ++i) {
            absolutePaths.add(new File(scanner.getBasedir(), scanner.getIncludedFiles()[i]).getAbsolutePath());
        }
        return absolutePaths;
    }

    public static File saveFile(String name, String data) {
        String fullyQualifiedName;
        if (name == null) {
            name = "";
        }
        if (!new File(fullyQualifiedName = name).isAbsolute()) {
            fullyQualifiedName = Paths.get("", new String[0]).toAbsolutePath().toString() + "/" + name;
        }
        try {
            if (fullyQualifiedName.contains("/")) {
                File f = new File(fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("/")));
                f.mkdirs();
            }
            File file = new File(fullyQualifiedName);
            file.createNewFile();
            FileUtils.fileWrite((File)file, (String)"UTF-8", (String)data);
            log.info("Wrote: " + file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not create file " + name, e);
            return null;
        }
    }

    public static File loadFile(String path) {
        File f;
        if (path == null) {
            path = "/";
        }
        if ((f = new File(path)).exists()) {
            return f.getAbsoluteFile();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new File(Paths.get("", new String[0]).toAbsolutePath().toString() + path.trim());
    }

    public static boolean removeFile(String path) {
        File fileToRemove = FileUtil.loadFile(path);
        return fileToRemove.delete();
    }

    public static File copyFile(String source, String dest) {
        if (source != null && dest != null) {
            try {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(source);
                return FileUtil.saveFile(dest, IOUtil.toString((InputStream)in));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not copy source file: " + source + " to dest file: " + dest, e);
            }
        }
        return null;
    }
}

