/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.converter;

import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.DocWriter;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.ScenarioResults;
import com.github.cukedoctor.api.StepResults;
import com.github.cukedoctor.api.model.Example;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Row;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.FileUtil;
import com.github.cukedoctor.util.Formatter;
import java.io.File;
import java.util.List;

public class CukedoctorConverterImpl
implements CukedoctorConverter {
    private List<Feature> features;
    private DocumentAttributes documentAttributes;
    private DocWriter<StringBuilder> writer;
    private String filename;

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs, DocWriter<StringBuilder> writer) {
        this.features = features;
        this.documentAttributes = attrs;
        this.writer = writer;
    }

    @Override
    public DocumentAttributes getDocumentAttributes() {
        return this.documentAttributes;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public StringBuilder getDocumentation() {
        return this.writer.getCurrentDoc();
    }

    @Override
    public String renderDocumentation() {
        this.writer.clear();
        this.renderAttributes();
        this.writer.write((Object)Constants.newLine());
        this.writer.write(Constants.Markup.H1(Constants.Markup.bold(this.documentAttributes.getDocTitle())), Constants.newLine(), Constants.newLine());
        this.renderSummary();
        this.writer.write(Constants.newLine(), Constants.newLine());
        this.writer.write(Constants.Markup.H2(Constants.Markup.bold("Features")), Constants.newLine(), Constants.newLine());
        this.renderFeatures(this.features);
        return this.writer.getCurrentDoc().toString();
    }

    @Override
    public CukedoctorConverter renderAttributes() {
        this.writer.write(Constants.Atributes.toc(this.documentAttributes.getToc()), Constants.newLine()).write(Constants.Atributes.backend(this.documentAttributes.getBackend()), Constants.newLine()).write(Constants.Atributes.docTitle(this.documentAttributes.getDocTitle()), Constants.newLine()).write(Constants.Atributes.docType(this.documentAttributes.getDocType()), Constants.newLine()).write(Constants.Atributes.icons(this.documentAttributes.getIcons()), Constants.newLine()).write(Constants.Atributes.numbered(this.documentAttributes.isNumbered()), Constants.newLine()).write(Constants.Atributes.linkcss(this.documentAttributes.isLinkCss()), Constants.newLine()).write(Constants.Atributes.sectAnchors(this.documentAttributes.isSectAnchors()), Constants.newLine()).write(Constants.Atributes.sectLink(this.documentAttributes.isSectLink()), Constants.newLine()).write(Constants.Atributes.docInfo(this.documentAttributes.isDocInfo()), Constants.newLine()).write(Constants.Atributes.tocLevels(this.documentAttributes.getTocLevels()), Constants.newLine());
        return this;
    }

    @Override
    public CukedoctorConverter generateDocInfo() {
        if (this.documentAttributes.isDocInfo()) {
            String docInfoName = this.filename.substring(0, this.filename.lastIndexOf(".")) + "-docinfo.html";
            File savedFile = FileUtil.copyFile("docinfo.html", docInfoName);
            String basePath = "";
            if (Assert.contains(this.filename, "/")) {
                basePath = this.filename.substring(0, this.filename.lastIndexOf("/"));
            }
            FileUtil.copyFile("cukedoctor.js", basePath + "/cukedoctor.js");
            FileUtil.copyFile("cukedoctor.css", basePath + "/cukedoctor.css");
        }
        return this;
    }

    @Override
    public CukedoctorConverter generatePdfTheme() {
        if (this.documentAttributes.isPdfTheme()) {
            String pdfThemeName = this.filename.substring(0, this.filename.lastIndexOf(".")) + "-theme.yml";
            FileUtil.copyFile("theme.yml", pdfThemeName);
        }
        return this;
    }

    @Override
    public CukedoctorConverterImpl renderSummary() {
        this.writer.write((Object)Constants.Markup.H2(Constants.Markup.bold("Summary"))).write((Object)Constants.newLine());
        this.writer.write((Object)("[cols=\"12*^m\", options=\"header,footer\"]" + Constants.newLine() + "|===" + Constants.newLine() + "3+|Scenarios 7+|Steps 2+|Features: " + this.features.size() + "" + Constants.newLine() + Constants.newLine() + "|[green]#*Passed*#" + Constants.newLine() + "|[red]#*Failed*#" + Constants.newLine() + "|Total" + Constants.newLine() + "|[green]#*Passed*#" + Constants.newLine() + "|[red]#*Failed*#" + Constants.newLine() + "|[purple]#*Skipped*#" + Constants.newLine() + "|[maroon]#*Pending*#" + Constants.newLine() + "|[yellow]#*Undefined*#" + Constants.newLine() + "|[blue]#*Missing*#" + Constants.newLine() + "|Total" + Constants.newLine() + "|Duration" + Constants.newLine() + "|Status" + Constants.newLine()));
        for (Feature feature : this.features) {
            this.writer.write((Object)Constants.newLine());
            this.writer.write("12+^" + Constants.Markup.tableCol(), "*<<", feature.getName().replaceAll(",", "").replaceAll(" ", "-"), ">>*", Constants.newLine());
            StepResults stepResults = feature.getStepResults();
            ScenarioResults scenarioResults = feature.getScenarioResults();
            this.writer.write(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenariosPassed(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenariosFailed(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenarios(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfPasses(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfFailures(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfSkipped(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfPending(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfUndefined(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfMissing(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getNumberOfSteps(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), stepResults.getTotalDurationAsString(), Constants.newLine());
            this.writer.write(Constants.Markup.tableCol(), Status.getStatusColor(feature.getStatus()), Constants.newLine());
        }
        this.renderTotalsRow();
        this.writer.write((Object)Constants.Markup.table());
        return this;
    }

    @Override
    public CukedoctorConverterImpl renderTotalsRow() {
        int totalPassedScenarios = 0;
        int totalFailedScenarios = 0;
        int totalScenarios = 0;
        int totalPassedSteps = 0;
        int totalFailedSteps = 0;
        int totalSkippedSteps = 0;
        int totalPendingSteps = 0;
        int totalMissingSteps = 0;
        int totalUndefinedSteps = 0;
        int totalSteps = 0;
        long totalDuration = 0L;
        for (Feature feature : this.features) {
            totalPassedScenarios += feature.getScenarioResults().getNumberOfScenariosPassed().intValue();
            totalFailedScenarios += feature.getScenarioResults().getNumberOfScenariosFailed().intValue();
            totalScenarios += feature.getNumberOfScenarios().intValue();
            totalPassedSteps += feature.getStepResults().getNumberOfPasses();
            totalFailedSteps += feature.getStepResults().getNumberOfFailures();
            totalSkippedSteps += feature.getStepResults().getNumberOfSkipped();
            totalPendingSteps += feature.getStepResults().getNumberOfPending();
            totalMissingSteps += feature.getStepResults().getNumberOfMissing();
            totalUndefinedSteps += feature.getStepResults().getNumberOfUndefined();
            totalSteps += feature.getNumberOfSteps().intValue();
            totalDuration += feature.getStepResults().getTotalDuration();
        }
        this.writer.write("12+^|*Totals*", Constants.newLine()).write(Constants.Markup.tableCol(), totalPassedScenarios, Constants.Markup.tableCol(), totalFailedScenarios).write(Constants.Markup.tableCol(), totalScenarios).write(Constants.Markup.tableCol(), totalPassedSteps, Constants.Markup.tableCol(), totalFailedSteps).write(Constants.Markup.tableCol(), totalSkippedSteps, Constants.Markup.tableCol(), totalPendingSteps).write(Constants.Markup.tableCol(), totalUndefinedSteps, Constants.Markup.tableCol(), totalMissingSteps).write(Constants.Markup.tableCol(), totalSteps, " 2+", Constants.Markup.tableCol(), Formatter.formatTime(totalDuration));
        this.writer.write((Object)Constants.newLine());
        return this;
    }

    @Override
    public CukedoctorConverter renderFeatures(List<Feature> features) {
        for (Feature feature : features) {
            this.renderFeature(feature);
        }
        return this;
    }

    @Override
    public CukedoctorConverterImpl renderFeature(Feature feature) {
        if (feature.hasIgnoreDocsTag()) {
            return this;
        }
        this.writer.write(this.renderFeatureSectionId(feature), Constants.newLine());
        this.writer.write(Constants.Markup.H3(Constants.Markup.bold(feature.getName())), Constants.newLine(), Constants.newLine());
        if (Assert.hasText(feature.getDescription())) {
            this.writer.write("****", Constants.newLine()).write((Object)feature.getDescription().trim().replaceAll("\\n", " +" + Constants.newLine())).write(Constants.newLine(), "****", Constants.newLine(), Constants.newLine());
        }
        this.renderFeatureScenarios(feature);
        return this;
    }

    @Override
    public String renderFeatureSectionId(Feature feature) {
        if (Assert.isNull(feature) || Assert.not(Assert.hasText(feature.getName()))) {
            return "";
        }
        return "[[" + feature.getName().replaceAll(",", "").replaceAll(" ", "-") + ", " + feature.getName() + "]]";
    }

    @Override
    public CukedoctorConverterImpl renderFeatureScenarios(Feature feature) {
        for (Scenario scenario : feature.getScenarios()) {
            if (scenario.hasIgnoreDocsTag()) continue;
            this.writer.write(Constants.Markup.H4(scenario.getKeyword()), ": ", scenario.getName(), Constants.newLine());
            if (feature.hasTags() || scenario.hasTags()) {
                this.renderScenarioTags(feature, scenario);
                this.writer.write(Constants.newLine(), Constants.newLine());
            }
            this.writer.write(scenario.getDescription(), Constants.newLine());
            if (scenario.hasExamples()) {
                this.renderScenarioExamples(scenario);
            }
            if (scenario.hasSteps()) {
                this.renderScenarioSteps((List)scenario.getSteps());
            }
            this.writer.write((Object)Constants.newLine());
        }
        return this;
    }

    @Override
    public CukedoctorConverter renderScenarioTags(Feature feature, Scenario scenario) {
        this.writer.write((Object)"[small]#tags: ");
        StringBuilder tags = new StringBuilder();
        if (feature.hasTags()) {
            for (Tag featureTag : feature.getTags()) {
                tags.append(featureTag.getName()).append(",");
            }
        }
        if (scenario.hasTags()) {
            for (Tag scenarioTag : scenario.getTags()) {
                tags.append(scenarioTag.getName()).append(",");
            }
        }
        if (tags.indexOf(",") != -1) {
            tags.deleteCharAt(tags.lastIndexOf(","));
        }
        this.writer.write((Object)tags.toString());
        this.writer.write((Object)"#");
        return this;
    }

    @Override
    public CukedoctorConverterImpl renderScenarioSteps(List<Step> steps) {
        this.writer.write("****", Constants.newLine());
        for (Step step : steps) {
            this.writer.write(step.getKeyword(), "::", Constants.newLine());
            this.writer.write(step.getName() + " ", Status.getStatusIcon(step.getStatus()));
            this.writer.write((Object)this.renderStepTime(step.getResult())).write((Object)Constants.newLine());
            this.renderStepTable(step);
            if (Assert.notNull(step.getDocString()) && Assert.hasText(step.getDocString().getValue())) {
                this.writer.write(Constants.Markup.listing(), Constants.newLine(), Constants.newLine());
                this.writer.write((Object)step.getDocString().getValue().replaceAll("\\n", Constants.newLine()));
                this.writer.write(Constants.newLine(), Constants.newLine(), Constants.Markup.listing(), Constants.newLine());
            }
            if (step.getResult() == null || Status.passed.equals((Object)step.getStatus()) || step.getResult().getErrorMessage() == null) continue;
            this.writer.write(Constants.newLine(), "IMPORTANT: ", step.getResult().getErrorMessage(), Constants.newLine());
        }
        this.writer.write("****", Constants.newLine());
        return this;
    }

    @Override
    public CukedoctorConverter renderStepTable(Step step) {
        if (Assert.notEmpty(step.getRows())) {
            this.writer.write(Constants.newLine(), Constants.newLine(), "[cols=\"" + step.getRows()[0].getCells().length + "*\", options=\"header\"]", Constants.newLine());
            this.writer.write(Constants.Markup.table(), Constants.newLine());
            Row header = step.getRows()[0];
            for (String col : header.getCells()) {
                this.writer.write(Constants.Markup.tableCol(), col, Constants.newLine());
            }
            for (int i = 1; i < step.getRows().length; ++i) {
                for (String cell : step.getRows()[i].getCells()) {
                    this.writer.write(Constants.Markup.tableCol(), cell, Constants.newLine());
                }
            }
            this.writer.write(Constants.Markup.table(), Constants.newLine(), Constants.newLine());
        }
        return this;
    }

    public String renderStepTime(Result result) {
        if (result == null || result.getDuration() == null) {
            return "";
        }
        return " [small right]#(" + Formatter.formatTime(result.getDuration()) + ")#";
    }

    @Override
    public CukedoctorConverter setFilename(String filename) {
        if (filename == null) {
            filename = this.documentAttributes.getDocTitle();
        }
        if (!filename.contains(".")) {
            filename = filename + ".adoc";
        }
        if (!FileUtil.ADOC_FILE_EXTENSION.matcher(filename = filename.replaceAll(" ", "_")).matches()) {
            throw new RuntimeException("Invalid filename extension for file: " + filename + ". Valid formats are: ad, adoc, asciidoc and asc");
        }
        this.filename = filename;
        return this;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public CukedoctorConverter saveDocumentation() {
        FileUtil.saveFile(this.filename, this.renderDocumentation());
        return this;
    }

    @Override
    public CukedoctorConverter renderScenarioExamples(Scenario scenario) {
        if (scenario.hasExamples()) {
            this.writer.write((Object)Constants.newLine());
            for (Example example : scenario.getExamples()) {
                this.writer.write("." + (example.getName() == null || "".equals(example.getName()) ? "Example" : example.getName()), Constants.newLine());
                this.writer.write("[cols=\"" + example.getRows()[0].getCells().length + "*\", options=\"header\"]", Constants.newLine());
                this.writer.write(Constants.Markup.table(), Constants.newLine());
                Row header = example.getRows()[0];
                for (String col : header.getCells()) {
                    this.writer.write(Constants.Markup.tableCol(), col, Constants.newLine());
                }
                for (int i = 1; i < example.getRows().length; ++i) {
                    for (String cell : example.getRows()[i].getCells()) {
                        this.writer.write(Constants.Markup.tableCol(), cell, Constants.newLine());
                    }
                }
                this.writer.write(Constants.Markup.table(), Constants.newLine(), Constants.newLine());
            }
        }
        return this;
    }
}

