/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor;

import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.converter.CukedoctorConverterImpl;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.DocWriterImpl;
import java.util.List;

public class Cukedoctor {
    public static CukedoctorConverter instance(List<Feature> features, DocumentAttributes attrs) {
        if (!Assert.hasElements(features)) {
            throw new RuntimeException("No features found");
        }
        if (attrs == null) {
            attrs = new DocumentAttributes();
        }
        if (!Assert.hasText(attrs.getDocTitle())) {
            attrs.docTitle("Living Documentation");
        }
        StringBuilder documentation = new StringBuilder();
        DocWriterImpl writer = DocWriterImpl.getInstance(documentation);
        CukedoctorConverterImpl instance = new CukedoctorConverterImpl(features, attrs, writer);
        instance.setFilename(attrs.getDocTitle().replaceAll(" ", "_") + ".adoc");
        return instance;
    }

    public static CukedoctorConverter instance(List<Feature> features) {
        return Cukedoctor.instance(features, new DocumentAttributes());
    }
}

