/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.GlobalFlagValues;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.IDrawingCache;

public abstract class BaseDanmaku {
    public static final String DANMAKU_BR_CHAR = "/n";
    public static final int TYPE_SCROLL_RL = 1;
    public static final int TYPE_SCROLL_LR = 6;
    public static final int TYPE_FIX_TOP = 5;
    public static final int TYPE_FIX_BOTTOM = 4;
    public static final int TYPE_SPECIAL = 7;
    public static final int TYPE_MOVEABLE_XXX = 0;
    public static final int INVISIBLE = 0;
    public static final int VISIBLE = 1;
    public static final int FLAG_REQUEST_REMEASURE = 1;
    public static final int FLAG_REQUEST_INVALIDATE = 2;
    public long time;
    public CharSequence text;
    public String[] lines;
    public Object obj;
    public int textColor;
    public float rotationZ;
    public float rotationY;
    public int textShadowColor;
    public int underlineColor = 0;
    public float textSize = -1.0f;
    public int borderColor = 0;
    public int padding = 0;
    public byte priority = 0;
    public float paintWidth = -1.0f;
    public float paintHeight = -1.0f;
    public Duration duration;
    public int index;
    public int visibility;
    private int visibleResetFlag = 0;
    public int measureResetFlag = 0;
    public IDrawingCache<?> cache;
    public boolean isLive;
    public boolean forceBuildCacheInSameThread;
    public int userId = 0;
    public String userHash;
    public boolean isGuest;
    protected DanmakuTimer mTimer;
    protected int alpha = AlphaValue.MAX;
    public int mFilterParam = 0;
    public int filterResetFlag = -1;
    public GlobalFlagValues flags = null;
    public int requestFlags = 0;
    public int firstShownFlag = -1;

    public long getDuration() {
        return this.duration.value;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public int draw(IDisplayer displayer) {
        return displayer.draw(this);
    }

    public boolean isMeasured() {
        return this.paintWidth > -1.0f && this.paintHeight > -1.0f && this.measureResetFlag == this.flags.MEASURE_RESET_FLAG;
    }

    public void measure(IDisplayer displayer, boolean fromWorkerThread) {
        displayer.measure(this, fromWorkerThread);
        this.measureResetFlag = this.flags.MEASURE_RESET_FLAG;
    }

    public boolean hasDrawingCache() {
        return this.cache != null && this.cache.get() != null;
    }

    public boolean isShown() {
        return this.visibility == 1 && this.visibleResetFlag == this.flags.VISIBLE_RESET_FLAG;
    }

    public boolean isTimeOut() {
        return this.mTimer == null || this.isTimeOut(this.mTimer.currMillisecond);
    }

    public boolean isTimeOut(long ctime) {
        return ctime - this.time >= this.duration.value;
    }

    public boolean isOutside() {
        return this.mTimer == null || this.isOutside(this.mTimer.currMillisecond);
    }

    public boolean isOutside(long ctime) {
        long dtime = ctime - this.time;
        return dtime <= 0L || dtime >= this.duration.value;
    }

    public boolean isLate() {
        return this.mTimer == null || this.mTimer.currMillisecond < this.time;
    }

    public boolean hasPassedFilter() {
        if (this.filterResetFlag != this.flags.FILTER_RESET_FLAG) {
            this.mFilterParam = 0;
            return false;
        }
        return true;
    }

    public boolean isFiltered() {
        return this.filterResetFlag == this.flags.FILTER_RESET_FLAG && this.mFilterParam != 0;
    }

    public boolean isFilteredBy(int flag) {
        return this.filterResetFlag == this.flags.FILTER_RESET_FLAG && (this.mFilterParam & flag) == flag;
    }

    public void setVisibility(boolean b) {
        if (b) {
            this.visibleResetFlag = this.flags.VISIBLE_RESET_FLAG;
            this.visibility = 1;
        } else {
            this.visibility = 0;
        }
    }

    public abstract void layout(IDisplayer var1, float var2, float var3);

    public abstract float[] getRectAtTime(IDisplayer var1, long var2);

    public abstract float getLeft();

    public abstract float getTop();

    public abstract float getRight();

    public abstract float getBottom();

    public abstract int getType();

    public DanmakuTimer getTimer() {
        return this.mTimer;
    }

    public void setTimer(DanmakuTimer timer) {
        this.mTimer = timer;
    }

    public int getAlpha() {
        return this.alpha;
    }
}

