/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.controller;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import java.util.LinkedList;
import master.flame.danmaku.controller.CacheManagingDrawTask;
import master.flame.danmaku.controller.DrawTask;
import master.flame.danmaku.controller.IDanmakuViewController;
import master.flame.danmaku.controller.IDrawTask;
import master.flame.danmaku.controller.UpdateThread;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.util.AndroidUtils;
import master.flame.danmaku.danmaku.util.SystemClock;
import tv.cjump.jni.DeviceUtils;

public class DrawHandler
extends Handler {
    private DanmakuContext mContext;
    public static final int START = 1;
    public static final int UPDATE = 2;
    public static final int RESUME = 3;
    public static final int SEEK_POS = 4;
    public static final int PREPARE = 5;
    private static final int QUIT = 6;
    private static final int PAUSE = 7;
    private static final int SHOW_DANMAKUS = 8;
    private static final int HIDE_DANMAKUS = 9;
    private static final int NOTIFY_DISP_SIZE_CHANGED = 10;
    private static final int NOTIFY_RENDERING = 11;
    private static final int UPDATE_WHEN_PAUSED = 12;
    private static final int CLEAR_DANMAKUS_ON_SCREEN = 13;
    private static final long INDEFINITE_TIME = 10000000L;
    private long pausedPosition = 0L;
    private boolean quitFlag = true;
    private long mTimeBase;
    private boolean mReady;
    private Callback mCallback;
    private DanmakuTimer timer = new DanmakuTimer();
    private BaseDanmakuParser mParser;
    public IDrawTask drawTask;
    private IDanmakuViewController mDanmakuView;
    private boolean mDanmakusVisible = true;
    private AbsDisplayer mDisp;
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private static final int MAX_RECORD_SIZE = 500;
    private LinkedList<Long> mDrawTimes = new LinkedList();
    private UpdateThread mThread;
    private final boolean mUpdateInNewThread = Runtime.getRuntime().availableProcessors() > 3;
    private long mCordonTime = 30L;
    private long mCordonTime2 = 60L;
    private long mFrameUpdateRate = 16L;
    private long mThresholdTime;
    private long mLastDeltaTime;
    private boolean mInSeekingAction;
    private long mDesireSeekingTime;
    private long mRemainingTime;
    private boolean mInSyncAction;
    private boolean mInWaitingState;
    private boolean mIdleSleep = !DeviceUtils.isProblemBoxDevice();

    public DrawHandler(Looper looper, IDanmakuViewController view, boolean danmakuVisibile) {
        super(looper);
        this.bindView(view);
        if (danmakuVisibile) {
            this.showDanmakus(null);
        } else {
            this.hideDanmakus(false);
        }
        this.mDanmakusVisible = danmakuVisibile;
    }

    private void bindView(IDanmakuViewController view) {
        this.mDanmakuView = view;
    }

    public void setConfig(DanmakuContext config) {
        this.mContext = config;
    }

    public void setParser(BaseDanmakuParser parser) {
        this.mParser = parser;
    }

    public void setCallback(Callback cb) {
        this.mCallback = cb;
    }

    public void quit() {
        this.sendEmptyMessage(6);
    }

    public boolean isStop() {
        return this.quitFlag;
    }

    public void handleMessage(Message msg) {
        int what = msg.what;
        switch (what) {
            case 5: {
                this.mTimeBase = SystemClock.uptimeMillis();
                if (this.mParser == null || !this.mDanmakuView.isViewReady()) {
                    this.sendEmptyMessageDelayed(5, 100L);
                    break;
                }
                this.prepare(new Runnable(){

                    @Override
                    public void run() {
                        DrawHandler.this.pausedPosition = 0L;
                        DrawHandler.this.mReady = true;
                        if (DrawHandler.this.mCallback != null) {
                            DrawHandler.this.mCallback.prepared();
                        }
                    }
                });
                break;
            }
            case 8: {
                this.mDanmakusVisible = true;
                Long start = (Long)msg.obj;
                boolean resume = false;
                if (this.drawTask != null) {
                    if (start == null) {
                        this.timer.update(this.getCurrentTime());
                        this.drawTask.requestClear();
                    } else {
                        this.drawTask.start();
                        this.drawTask.seek(start);
                        this.drawTask.requestClear();
                        resume = true;
                    }
                }
                if (this.quitFlag && this.mDanmakuView != null) {
                    this.mDanmakuView.drawDanmakus();
                }
                this.notifyRendering();
                if (!resume) break;
            }
            case 1: {
                Long startTime = (Long)msg.obj;
                this.pausedPosition = startTime != null ? startTime : 0L;
            }
            case 4: {
                if (what == 4) {
                    this.quitFlag = true;
                    this.quitUpdateThread();
                    Long position = (Long)msg.obj;
                    long deltaMs = position - this.timer.currMillisecond;
                    this.mTimeBase -= deltaMs;
                    this.timer.update(SystemClock.uptimeMillis() - this.mTimeBase);
                    this.mContext.mGlobalFlagValues.updateMeasureFlag();
                    if (this.drawTask != null) {
                        this.drawTask.seek(this.timer.currMillisecond);
                    }
                    this.pausedPosition = this.timer.currMillisecond;
                }
            }
            case 3: {
                this.quitFlag = false;
                if (this.mReady) {
                    this.mRenderingState.reset();
                    this.mDrawTimes.clear();
                    this.mTimeBase = SystemClock.uptimeMillis() - this.pausedPosition;
                    this.timer.update(this.pausedPosition);
                    this.removeMessages(3);
                    this.sendEmptyMessage(2);
                    this.drawTask.start();
                    this.notifyRendering();
                    this.mInSeekingAction = false;
                    break;
                }
                this.sendEmptyMessageDelayed(3, 100L);
                break;
            }
            case 2: {
                if (this.mUpdateInNewThread) {
                    this.updateInNewThread();
                    break;
                }
                this.updateInCurrentThread();
                break;
            }
            case 10: {
                this.mContext.mDanmakuFactory.notifyDispSizeChanged(this.mContext);
                Boolean updateFlag = (Boolean)msg.obj;
                if (updateFlag == null || !updateFlag.booleanValue()) break;
                this.mContext.mGlobalFlagValues.updateMeasureFlag();
                break;
            }
            case 9: {
                Boolean quitDrawTask;
                this.mDanmakusVisible = false;
                if (this.mDanmakuView != null) {
                    this.mDanmakuView.clear();
                }
                if (this.drawTask != null) {
                    this.drawTask.requestClear();
                    this.drawTask.requestHide();
                }
                if ((quitDrawTask = (Boolean)msg.obj).booleanValue() && this.drawTask != null) {
                    this.drawTask.quit();
                }
                if (!quitDrawTask.booleanValue()) break;
            }
            case 7: {
                this.removeMessages(2);
            }
            case 6: {
                if (what == 6) {
                    this.removeCallbacksAndMessages(null);
                }
                this.quitFlag = true;
                this.syncTimerIfNeeded();
                if (this.mThread != null) {
                    this.notifyRendering();
                    this.quitUpdateThread();
                }
                this.pausedPosition = this.timer.currMillisecond;
                if (what != 6) break;
                if (this.drawTask != null) {
                    this.drawTask.quit();
                }
                if (this.mParser != null) {
                    this.mParser.release();
                }
                if (this.getLooper() == Looper.getMainLooper()) break;
                this.getLooper().quit();
                break;
            }
            case 11: {
                this.notifyRendering();
                break;
            }
            case 12: {
                if (!this.quitFlag || this.mDanmakuView == null) break;
                this.drawTask.requestClear();
                this.mDanmakuView.drawDanmakus();
                this.notifyRendering();
                break;
            }
            case 13: {
                if (this.drawTask == null) break;
                this.drawTask.clearDanmakusOnScreen(this.getCurrentTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitUpdateThread() {
        if (this.mThread != null) {
            UpdateThread thread = this.mThread;
            this.mThread = null;
            IDrawTask iDrawTask = this.drawTask;
            synchronized (iDrawTask) {
                this.drawTask.notifyAll();
            }
            thread.quit();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateInCurrentThread() {
        long dTime;
        if (this.quitFlag) {
            return;
        }
        long startMS = SystemClock.uptimeMillis();
        long d = this.syncTimer(startMS);
        if (d < 0L) {
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(2, 60L - d);
            return;
        }
        d = this.mDanmakuView.drawDanmakus();
        this.removeMessages(2);
        if (d > this.mCordonTime2) {
            this.timer.add(d);
            this.mDrawTimes.clear();
        }
        if (!this.mDanmakusVisible) {
            this.waitRendering(10000000L);
            return;
        }
        if (this.mRenderingState.nothingRendered && this.mIdleSleep && (dTime = this.mRenderingState.endTime - this.timer.currMillisecond) > 500L) {
            this.waitRendering(dTime - 10L);
            return;
        }
        if (d < this.mFrameUpdateRate) {
            this.sendEmptyMessageDelayed(2, this.mFrameUpdateRate - d);
            return;
        }
        this.sendEmptyMessage(2);
    }

    private void updateInNewThread() {
        if (this.mThread != null) {
            return;
        }
        this.mThread = new UpdateThread("DFM Update"){

            @Override
            public void run() {
                long lastTime = SystemClock.uptimeMillis();
                long dTime = 0L;
                while (!this.isQuited() && !DrawHandler.this.quitFlag) {
                    long startMS = SystemClock.uptimeMillis();
                    dTime = SystemClock.uptimeMillis() - lastTime;
                    long diffTime = DrawHandler.this.mFrameUpdateRate - dTime;
                    if (diffTime > 1L) {
                        SystemClock.sleep(1L);
                        continue;
                    }
                    lastTime = startMS;
                    long d = DrawHandler.this.syncTimer(startMS);
                    if (d < 0L) {
                        SystemClock.sleep(60L - d);
                        continue;
                    }
                    d = DrawHandler.this.mDanmakuView.drawDanmakus();
                    if (d > DrawHandler.this.mCordonTime2) {
                        DrawHandler.this.timer.add(d);
                        DrawHandler.this.mDrawTimes.clear();
                    }
                    if (!DrawHandler.this.mDanmakusVisible) {
                        DrawHandler.this.waitRendering(10000000L);
                        continue;
                    }
                    if (!((DrawHandler)DrawHandler.this).mRenderingState.nothingRendered || !DrawHandler.this.mIdleSleep || (dTime = ((DrawHandler)DrawHandler.this).mRenderingState.endTime - ((DrawHandler)DrawHandler.this).timer.currMillisecond) <= 500L) continue;
                    DrawHandler.this.notifyRendering();
                    DrawHandler.this.waitRendering(dTime - 10L);
                }
            }
        };
        this.mThread.start();
    }

    private final long syncTimer(long startMS) {
        if (this.mInSeekingAction || this.mInSyncAction) {
            return 0L;
        }
        this.mInSyncAction = true;
        long d = 0L;
        long time = startMS - this.mTimeBase;
        if (!this.mDanmakusVisible || this.mRenderingState.nothingRendered || this.mInWaitingState) {
            this.timer.update(time);
            this.mRemainingTime = 0L;
        } else {
            long gapTime = time - this.timer.currMillisecond;
            long averageTime = Math.max(this.mFrameUpdateRate, this.getAverageRenderingTime());
            if (gapTime > 2000L || this.mRenderingState.consumingTime > this.mCordonTime || averageTime > this.mCordonTime) {
                d = gapTime;
                gapTime = 0L;
            } else {
                d = averageTime + gapTime / this.mFrameUpdateRate;
                d = Math.max(this.mFrameUpdateRate, d);
                long a = (d = Math.min(this.mCordonTime, d)) - this.mLastDeltaTime;
                if (a > 3L && a < 8L && this.mLastDeltaTime >= this.mFrameUpdateRate && this.mLastDeltaTime <= this.mCordonTime) {
                    d = this.mLastDeltaTime;
                }
                gapTime -= d;
                this.mLastDeltaTime = d;
            }
            this.mRemainingTime = gapTime;
            this.timer.add(d);
        }
        if (this.mCallback != null) {
            this.mCallback.updateTimer(this.timer);
        }
        this.mInSyncAction = false;
        return d;
    }

    private void syncTimerIfNeeded() {
        if (this.mInWaitingState) {
            this.syncTimer(SystemClock.uptimeMillis());
        }
    }

    private void initRenderingConfigs() {
        long averageFrameConsumingTime = 16L;
        this.mCordonTime = Math.max(33L, (long)((float)averageFrameConsumingTime * 2.5f));
        this.mCordonTime2 = (long)((float)this.mCordonTime * 2.5f);
        this.mFrameUpdateRate = Math.max(16L, averageFrameConsumingTime / 15L * 15L);
        this.mThresholdTime = this.mFrameUpdateRate + 3L;
    }

    private void prepare(final Runnable runnable) {
        if (this.drawTask == null) {
            this.drawTask = this.createDrawTask(this.mDanmakuView.isDanmakuDrawingCacheEnabled(), this.timer, this.mDanmakuView.getContext(), this.mDanmakuView.getWidth(), this.mDanmakuView.getHeight(), this.mDanmakuView.isHardwareAccelerated(), new IDrawTask.TaskListener(){

                @Override
                public void ready() {
                    DrawHandler.this.initRenderingConfigs();
                    runnable.run();
                }

                @Override
                public void onDanmakuAdd(BaseDanmaku danmaku) {
                    if (danmaku.isTimeOut()) {
                        return;
                    }
                    long delay = danmaku.time - ((DrawHandler)DrawHandler.this).timer.currMillisecond;
                    if (delay > 0L) {
                        DrawHandler.this.sendEmptyMessageDelayed(11, delay);
                    } else if (DrawHandler.this.mInWaitingState) {
                        DrawHandler.this.notifyRendering();
                    }
                }

                @Override
                public void onDanmakuShown(BaseDanmaku danmaku) {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.danmakuShown(danmaku);
                    }
                }

                @Override
                public void onDanmakusDrawingFinished() {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.drawingFinished();
                    }
                }

                @Override
                public void onDanmakuConfigChanged() {
                    DrawHandler.this.redrawIfNeeded();
                }
            });
        } else {
            runnable.run();
        }
    }

    public boolean isPrepared() {
        return this.mReady;
    }

    private IDrawTask createDrawTask(boolean useDrwaingCache, DanmakuTimer timer, Context context, int width, int height, boolean isHardwareAccelerated, IDrawTask.TaskListener taskListener) {
        this.mDisp = this.mContext.getDisplayer();
        this.mDisp.setSize(width, height);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDisp.setDensities(displayMetrics.density, displayMetrics.densityDpi, displayMetrics.scaledDensity);
        this.mDisp.resetSlopPixel(this.mContext.scaleTextSize);
        this.mDisp.setHardwareAccelerated(isHardwareAccelerated);
        DrawTask task = useDrwaingCache ? new CacheManagingDrawTask(timer, this.mContext, taskListener, 0x100000 * AndroidUtils.getMemoryClass(context) / 3) : new DrawTask(timer, this.mContext, taskListener);
        task.setParser(this.mParser);
        task.prepare();
        this.obtainMessage(10, false).sendToTarget();
        return task;
    }

    public void seekTo(Long ms) {
        this.mInSeekingAction = true;
        this.mDesireSeekingTime = ms;
        this.removeMessages(2);
        this.removeMessages(3);
        this.removeMessages(4);
        this.obtainMessage(4, ms).sendToTarget();
    }

    public void addDanmaku(BaseDanmaku item) {
        if (this.drawTask != null) {
            item.flags = this.mContext.mGlobalFlagValues;
            item.setTimer(this.timer);
            this.drawTask.addDanmaku(item);
            this.obtainMessage(11).sendToTarget();
        }
    }

    public void invalidateDanmaku(BaseDanmaku item, boolean remeasure) {
        if (this.drawTask != null && item != null) {
            this.drawTask.invalidateDanmaku(item, remeasure);
        }
        this.redrawIfNeeded();
    }

    public void resume() {
        this.sendEmptyMessage(3);
    }

    public void prepare() {
        this.sendEmptyMessage(5);
    }

    public void pause() {
        this.syncTimerIfNeeded();
        this.sendEmptyMessage(7);
    }

    public void showDanmakus(Long position) {
        if (this.mDanmakusVisible) {
            return;
        }
        this.mDanmakusVisible = true;
        this.removeMessages(8);
        this.removeMessages(9);
        this.obtainMessage(8, position).sendToTarget();
    }

    public long hideDanmakus(boolean quitDrawTask) {
        if (!this.mDanmakusVisible) {
            return this.timer.currMillisecond;
        }
        this.mDanmakusVisible = false;
        this.removeMessages(8);
        this.removeMessages(9);
        this.obtainMessage(9, quitDrawTask).sendToTarget();
        return this.timer.currMillisecond;
    }

    public boolean getVisibility() {
        return this.mDanmakusVisible;
    }

    public IRenderer.RenderingState draw(Canvas canvas) {
        if (this.drawTask == null) {
            return this.mRenderingState;
        }
        this.mDisp.setExtraData(canvas);
        this.mRenderingState.set(this.drawTask.draw(this.mDisp));
        this.recordRenderingTime();
        return this.mRenderingState;
    }

    private void redrawIfNeeded() {
        if (this.quitFlag && this.mDanmakusVisible) {
            this.obtainMessage(12).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRendering() {
        if (!this.mInWaitingState) {
            return;
        }
        if (this.drawTask != null) {
            this.drawTask.requestClear();
        }
        if (this.mUpdateInNewThread) {
            Object object = this;
            synchronized (object) {
                this.mDrawTimes.clear();
            }
            object = this.drawTask;
            synchronized (object) {
                this.drawTask.notifyAll();
            }
        }
        this.mDrawTimes.clear();
        this.removeMessages(2);
        this.sendEmptyMessage(2);
        this.mInWaitingState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRendering(long dTime) {
        this.mRenderingState.sysTime = SystemClock.uptimeMillis();
        this.mInWaitingState = true;
        if (this.mUpdateInNewThread) {
            if (this.mThread == null) {
                return;
            }
            try {
                IDrawTask iDrawTask = this.drawTask;
                synchronized (iDrawTask) {
                    if (dTime == 10000000L) {
                        this.drawTask.wait();
                    } else {
                        this.drawTask.wait(dTime);
                    }
                    this.sendEmptyMessage(11);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (dTime == 10000000L) {
            this.removeMessages(11);
            this.removeMessages(2);
        } else {
            this.removeMessages(11);
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(11, dTime);
        }
    }

    private synchronized long getAverageRenderingTime() {
        int frames = this.mDrawTimes.size();
        if (frames <= 0) {
            return 0L;
        }
        long dtime = this.mDrawTimes.getLast() - this.mDrawTimes.getFirst();
        return dtime / (long)frames;
    }

    private synchronized void recordRenderingTime() {
        long lastTime = SystemClock.uptimeMillis();
        this.mDrawTimes.addLast(lastTime);
        int frames = this.mDrawTimes.size();
        if (frames > 500) {
            this.mDrawTimes.removeFirst();
            frames = 500;
        }
    }

    public IDisplayer getDisplayer() {
        return this.mDisp;
    }

    public void notifyDispSizeChanged(int width, int height) {
        if (this.mDisp == null) {
            return;
        }
        if (this.mDisp.getWidth() != width || this.mDisp.getHeight() != height) {
            this.mDisp.setSize(width, height);
            this.obtainMessage(10, true).sendToTarget();
        }
    }

    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.drawTask != null) {
            this.drawTask.removeAllDanmakus(isClearDanmakusOnScreen);
        }
    }

    public void removeAllLiveDanmakus() {
        if (this.drawTask != null) {
            this.drawTask.removeAllLiveDanmakus();
        }
    }

    public IDanmakus getCurrentVisibleDanmakus() {
        if (this.drawTask != null) {
            return this.drawTask.getVisibleDanmakusOnTime(this.getCurrentTime());
        }
        return null;
    }

    public long getCurrentTime() {
        if (!this.mReady) {
            return 0L;
        }
        if (this.mInSeekingAction) {
            return this.mDesireSeekingTime;
        }
        if (this.quitFlag || !this.mInWaitingState) {
            return this.timer.currMillisecond - this.mRemainingTime;
        }
        return SystemClock.uptimeMillis() - this.mTimeBase;
    }

    public void clearDanmakusOnScreen() {
        this.obtainMessage(13).sendToTarget();
    }

    public DanmakuContext getConfig() {
        return this.mContext;
    }

    public static interface Callback {
        public void prepared();

        public void updateTimer(DanmakuTimer var1);

        public void danmakuShown(BaseDanmaku var1);

        public void drawingFinished();
    }
}

