/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.DrawHelper;
import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.SpecialDanmaku;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import master.flame.danmaku.ui.widget.DanmakuView;

public class FakeDanmakuView
extends DanmakuView
implements DrawHandler.Callback {
    private DanmakuTimer mTimer;
    private boolean mIsRelease;
    private OnFrameAvailableListener mOnFrameAvailableListener;
    private int mWidth = 0;
    private int mHeight = 0;
    private float mScale = 1.0f;
    private DanmakuTimer mOuterTimer;
    private long mBeginTimeMills;
    private long mFrameIntervalMills = 16L;
    private long mEndTimeMills;
    private Bitmap mBufferBitmap;
    private Canvas mBufferCanvas;
    private int mRetryCount = 0;
    private long mExpectBeginMills = 0L;

    public FakeDanmakuView(Context context) {
        super(context);
    }

    public FakeDanmakuView(Context context, int width, int height, float scale) {
        super(context);
        this.mWidth = width;
        this.mHeight = height;
        this.mScale = scale;
        this.initBufferCanvas(width, height);
    }

    public void initBufferCanvas(int width, int height) {
        this.mBufferBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mBufferCanvas = new Canvas(this.mBufferBitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long drawDanmakus() {
        if (this.mIsRelease) {
            return 0L;
        }
        Canvas canvas = this.mBufferCanvas;
        if (canvas == null) {
            return 0L;
        }
        Bitmap bufferBitmap = this.mBufferBitmap;
        if (bufferBitmap == null || bufferBitmap.isRecycled()) {
            return 0L;
        }
        bufferBitmap.eraseColor(0);
        if (this.mClearFlag) {
            DrawHelper.clearCanvas(canvas);
            this.mClearFlag = false;
        } else if (this.handler != null) {
            this.handler.draw(canvas);
        }
        OnFrameAvailableListener onFrameAvailableListener = this.mOnFrameAvailableListener;
        if (onFrameAvailableListener != null) {
            long curr = this.mOuterTimer.currMillisecond;
            try {
                if (curr >= this.mExpectBeginMills - this.mFrameIntervalMills) {
                    Bitmap bitmap;
                    boolean recycle = false;
                    if (this.mScale == 1.0f) {
                        bitmap = bufferBitmap;
                    } else {
                        bitmap = Bitmap.createScaledBitmap((Bitmap)bufferBitmap, (int)((int)((float)this.mWidth * this.mScale)), (int)((int)((float)this.mHeight * this.mScale)), (boolean)true);
                        recycle = true;
                    }
                    onFrameAvailableListener.onFrameAvailable(curr, bitmap);
                    if (recycle) {
                        bitmap.recycle();
                    }
                }
            }
            catch (Exception e) {
                this.release();
                onFrameAvailableListener.onFailed(101, e.getMessage());
            }
            finally {
                if (curr >= this.mEndTimeMills) {
                    this.release();
                    if (this.mTimer != null) {
                        this.mTimer.update(this.mEndTimeMills);
                    }
                    onFrameAvailableListener.onFramesFinished(curr);
                }
            }
        }
        this.mRequestRender = false;
        return 2L;
    }

    @Override
    public void release() {
        this.mIsRelease = true;
        super.release();
        this.mBufferBitmap = null;
    }

    @Override
    protected void onDraw(Canvas canvas) {
    }

    @Override
    public boolean isShown() {
        return true;
    }

    @Override
    public boolean isViewReady() {
        return true;
    }

    @Override
    public int getViewWidth() {
        return this.mWidth;
    }

    @Override
    public int getViewHeight() {
        return this.mHeight;
    }

    @Override
    public void prepare(BaseDanmakuParser parser, DanmakuContext config) {
        DanmakuContext configCopy;
        CustomParser newParser = new CustomParser(parser, this.mBeginTimeMills, this.mEndTimeMills);
        try {
            configCopy = (DanmakuContext)config.clone();
            configCopy.resetContext();
            configCopy.transparency = AlphaValue.MAX;
            configCopy.setDanmakuTransparency((float)config.transparency / (float)AlphaValue.MAX);
            configCopy.mGlobalFlagValues.FILTER_RESET_FLAG = config.mGlobalFlagValues.FILTER_RESET_FLAG;
            configCopy.setDanmakuSync(null);
            configCopy.unregisterAllConfigChangedCallbacks();
            configCopy.mGlobalFlagValues.updateAll();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            configCopy = config;
        }
        configCopy.updateMethod = 1;
        if (this.mOnFrameAvailableListener != null) {
            this.mOnFrameAvailableListener.onConfig(configCopy);
        }
        super.prepare(newParser, configCopy);
        this.handler.setIdleSleep(false);
        this.handler.enableNonBlockMode(true);
    }

    public void setTimeRange(long beginMills, long endMills) {
        this.mExpectBeginMills = beginMills;
        this.mBeginTimeMills = Math.max(0L, beginMills - 30000L);
        this.mEndTimeMills = endMills;
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener onFrameAvailableListener) {
        this.mOnFrameAvailableListener = onFrameAvailableListener;
    }

    public void getFrameAtTime(final int frameRate) {
        if (this.mRetryCount++ > 5) {
            this.release();
            if (this.mOnFrameAvailableListener != null) {
                this.mOnFrameAvailableListener.onFailed(100, "not prepared");
            }
            return;
        }
        if (!this.isPrepared()) {
            DrawHandler handler = this.handler;
            if (handler == null) {
                return;
            }
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FakeDanmakuView.this.getFrameAtTime(frameRate);
                }
            }, 1000L);
            return;
        }
        this.mFrameIntervalMills = 1000 / frameRate;
        this.setCallback(this);
        long beginMills = Math.max(0L, this.mExpectBeginMills - this.getConfig().mDanmakuFactory.MAX_DANMAKU_DURATION * 3L / 2L);
        this.mOuterTimer = new DanmakuTimer(beginMills);
        this.start(beginMills);
    }

    @Override
    public void prepared() {
    }

    @Override
    public void updateTimer(DanmakuTimer timer) {
        this.mTimer = timer;
        timer.update(this.mOuterTimer.currMillisecond);
        this.mOuterTimer.add(this.mFrameIntervalMills);
        timer.add(this.mFrameIntervalMills);
    }

    @Override
    public void danmakuShown(BaseDanmaku danmaku) {
    }

    @Override
    public void drawingFinished() {
    }

    public static interface OnFrameAvailableListener {
        public void onConfig(DanmakuContext var1);

        public void onFrameAvailable(long var1, Bitmap var3);

        public void onFramesFinished(long var1);

        public void onFailed(int var1, String var2);
    }

    private class CustomParser
    extends BaseDanmakuParser {
        private final BaseDanmakuParser mBaseParser;
        private final long stTime;
        private final long edTime;
        private float mDispScaleX;
        private float mDispScaleY;
        private int mViewWidth;

        public CustomParser(BaseDanmakuParser baseParser, long stTime, long edTime) {
            this.mBaseParser = baseParser;
            this.stTime = stTime;
            this.edTime = edTime;
        }

        @Override
        protected IDanmakus parse() {
            IDanmakus subnew;
            final Danmakus danmakus = new Danmakus();
            try {
                subnew = this.mBaseParser.getDanmakus().subnew(this.stTime, this.edTime);
            }
            catch (Exception e) {
                subnew = this.mBaseParser.getDanmakus();
            }
            if (subnew == null) {
                return danmakus;
            }
            subnew.forEach(new IDanmakus.Consumer<BaseDanmaku, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int accept(BaseDanmaku danmaku) {
                    long time = danmaku.getTime();
                    if (time < CustomParser.this.stTime) {
                        return 0;
                    }
                    if (time > CustomParser.this.edTime) {
                        return 1;
                    }
                    BaseDanmaku item = ((CustomParser)CustomParser.this).mContext.mDanmakuFactory.createDanmaku(danmaku.getType(), CustomParser.this.mContext);
                    if (item != null) {
                        Object lock;
                        item.setTime(danmaku.getTime());
                        DanmakuUtils.fillText(item, danmaku.text);
                        item.textSize = danmaku.textSize;
                        item.textColor = danmaku.textColor;
                        item.textShadowColor = danmaku.textShadowColor;
                        if (danmaku instanceof SpecialDanmaku) {
                            SpecialDanmaku sdanmaku = (SpecialDanmaku)danmaku;
                            item.index = danmaku.index;
                            item.duration = new Duration(sdanmaku.getDuration());
                            item.rotationZ = sdanmaku.rotateZ;
                            item.rotationY = sdanmaku.rotationY;
                            ((SpecialDanmaku)item).isQuadraticEaseOut = sdanmaku.isQuadraticEaseOut;
                            ((CustomParser)CustomParser.this).mContext.mDanmakuFactory.fillTranslationData(item, sdanmaku.beginX, sdanmaku.beginY, sdanmaku.endX, sdanmaku.endY, sdanmaku.translationDuration, sdanmaku.translationStartDelay, CustomParser.this.mDispScaleX, CustomParser.this.mDispScaleY);
                            ((CustomParser)CustomParser.this).mContext.mDanmakuFactory.fillAlphaData(item, sdanmaku.beginAlpha, sdanmaku.endAlpha, item.getDuration());
                            return 0;
                        }
                        item.setTimer(CustomParser.this.mTimer);
                        item.mFilterParam = danmaku.mFilterParam;
                        item.filterResetFlag = danmaku.filterResetFlag;
                        item.flags = ((CustomParser)CustomParser.this).mContext.mGlobalFlagValues;
                        Object object = lock = danmakus.obtainSynchronizer();
                        synchronized (object) {
                            danmakus.addItem(item);
                        }
                    }
                    return 0;
                }
            });
            return danmakus;
        }

        @Override
        public BaseDanmakuParser setDisplayer(IDisplayer disp) {
            super.setDisplayer(disp);
            if (this.mBaseParser == null || this.mBaseParser.getDisplayer() == null) {
                return this;
            }
            this.mDispScaleX = (float)this.mDispWidth / (float)this.mBaseParser.getDisplayer().getWidth();
            this.mDispScaleY = (float)this.mDispHeight / (float)this.mBaseParser.getDisplayer().getHeight();
            if (this.mViewWidth <= 1) {
                this.mViewWidth = disp.getWidth();
            }
            return this;
        }

        @Override
        protected float getViewportSizeFactor() {
            float scale = (float)(3800L * (long)this.mViewWidth) / 682.0f;
            float factor = 1.1f;
            return (float)this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION * factor / scale;
        }
    }
}

