/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.ui.widget;

import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.Danmakus;

public class DanmakuTouchHelper {
    private final GestureDetector mTouchDelegate;
    private IDanmakuView danmakuView;
    private RectF mDanmakuBounds;
    private float mXOff;
    private float mYOff;
    private final GestureDetector.OnGestureListener mOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent event) {
            IDanmakuView.OnDanmakuClickListener onDanmakuClickListener;
            if (DanmakuTouchHelper.this.danmakuView != null && (onDanmakuClickListener = DanmakuTouchHelper.this.danmakuView.getOnDanmakuClickListener()) != null) {
                DanmakuTouchHelper.this.mXOff = DanmakuTouchHelper.this.danmakuView.getXOff();
                DanmakuTouchHelper.this.mYOff = DanmakuTouchHelper.this.danmakuView.getYOff();
                return true;
            }
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent event) {
            IDanmakus clickDanmakus = DanmakuTouchHelper.this.touchHitDanmaku(event.getX(), event.getY());
            boolean isEventConsumed = false;
            if (null != clickDanmakus && !clickDanmakus.isEmpty()) {
                isEventConsumed = DanmakuTouchHelper.this.performDanmakuClick(clickDanmakus, false);
            }
            if (!isEventConsumed) {
                isEventConsumed = DanmakuTouchHelper.this.performViewClick();
            }
            return isEventConsumed;
        }

        public void onLongPress(MotionEvent event) {
            IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = DanmakuTouchHelper.this.danmakuView.getOnDanmakuClickListener();
            if (onDanmakuClickListener == null) {
                return;
            }
            DanmakuTouchHelper.this.mXOff = DanmakuTouchHelper.this.danmakuView.getXOff();
            DanmakuTouchHelper.this.mYOff = DanmakuTouchHelper.this.danmakuView.getYOff();
            IDanmakus clickDanmakus = DanmakuTouchHelper.this.touchHitDanmaku(event.getX(), event.getY());
            if (null != clickDanmakus && !clickDanmakus.isEmpty()) {
                DanmakuTouchHelper.this.performDanmakuClick(clickDanmakus, true);
            }
        }
    };

    private DanmakuTouchHelper(IDanmakuView danmakuView) {
        this.danmakuView = danmakuView;
        this.mDanmakuBounds = new RectF();
        this.mTouchDelegate = new GestureDetector(((View)danmakuView).getContext(), this.mOnGestureListener);
    }

    public static synchronized DanmakuTouchHelper instance(IDanmakuView danmakuView) {
        return new DanmakuTouchHelper(danmakuView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mTouchDelegate.onTouchEvent(event);
    }

    private boolean performDanmakuClick(IDanmakus danmakus, boolean isLongClick) {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            if (isLongClick) {
                return onDanmakuClickListener.onDanmakuLongClick(danmakus);
            }
            return onDanmakuClickListener.onDanmakuClick(danmakus);
        }
        return false;
    }

    private boolean performViewClick() {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            return onDanmakuClickListener.onViewClick(this.danmakuView);
        }
        return false;
    }

    private IDanmakus touchHitDanmaku(final float x, final float y) {
        final Danmakus hitDanmakus = new Danmakus();
        this.mDanmakuBounds.setEmpty();
        IDanmakus danmakus = this.danmakuView.getCurrentVisibleDanmakus();
        if (null != danmakus && !danmakus.isEmpty()) {
            danmakus.forEachSync(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                @Override
                public int accept(BaseDanmaku danmaku) {
                    if (null != danmaku) {
                        DanmakuTouchHelper.this.mDanmakuBounds.set(danmaku.getLeft(), danmaku.getTop(), danmaku.getRight(), danmaku.getBottom());
                        if (DanmakuTouchHelper.this.mDanmakuBounds.intersect(x - DanmakuTouchHelper.this.mXOff, y - DanmakuTouchHelper.this.mYOff, x + DanmakuTouchHelper.this.mXOff, y + DanmakuTouchHelper.this.mYOff)) {
                            hitDanmakus.addItem(danmaku);
                        }
                    }
                    return 0;
                }
            });
        }
        return hitDanmakus;
    }
}

