/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.util.DanmakuUtils;

public class DanmakusRetainer {
    private IDanmakusRetainer rldrInstance = null;
    private IDanmakusRetainer lrdrInstance = null;
    private IDanmakusRetainer ftdrInstance = null;
    private IDanmakusRetainer fbdrInstance = null;

    public DanmakusRetainer(boolean alignBottom) {
        this.alignBottom(alignBottom);
    }

    public void alignBottom(boolean alignBottom) {
        this.rldrInstance = alignBottom ? new AlignBottomRetainer() : new AlignTopRetainer();
        IDanmakusRetainer iDanmakusRetainer = this.lrdrInstance = alignBottom ? new AlignBottomRetainer() : new AlignTopRetainer();
        if (this.ftdrInstance == null) {
            this.ftdrInstance = new FTDanmakusRetainer();
        }
        if (this.fbdrInstance == null) {
            this.fbdrInstance = new AlignBottomRetainer();
        }
    }

    public void fix(BaseDanmaku danmaku, IDisplayer disp, Verifier verifier) {
        int type = danmaku.getType();
        switch (type) {
            case 1: {
                this.rldrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 6: {
                this.lrdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 5: {
                this.ftdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 4: {
                this.fbdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 7: {
                danmaku.layout(disp, 0.0f, 0.0f);
            }
        }
    }

    public void clear() {
        if (this.rldrInstance != null) {
            this.rldrInstance.clear();
        }
        if (this.lrdrInstance != null) {
            this.lrdrInstance.clear();
        }
        if (this.ftdrInstance != null) {
            this.ftdrInstance.clear();
        }
        if (this.fbdrInstance != null) {
            this.fbdrInstance.clear();
        }
    }

    public void release() {
        this.clear();
    }

    private static class AlignBottomRetainer
    extends FTDanmakusRetainer {
        protected RetainerConsumer mConsumer = new RetainerConsumer();
        protected Danmakus mVisibleDanmakus = new Danmakus(2);

        private AlignBottomRetainer() {
        }

        @Override
        public void fix(BaseDanmaku drawItem, IDisplayer disp, Verifier verifier) {
            if (drawItem.isOutside()) {
                return;
            }
            boolean shown = drawItem.isShown();
            float topPos = shown ? drawItem.getTop() : -1.0f;
            int lines = 0;
            boolean willHit = !shown && !this.mVisibleDanmakus.isEmpty();
            boolean isOutOfVerticalEdge = false;
            if (topPos < (float)disp.getAllMarginTop()) {
                topPos = (float)disp.getHeight() - drawItem.paintHeight;
            }
            BaseDanmaku removeItem = null;
            BaseDanmaku firstItem = null;
            if (!shown) {
                this.mCancelFixingFlag = false;
                this.mConsumer.topPos = topPos;
                this.mConsumer.disp = disp;
                this.mConsumer.drawItem = drawItem;
                this.mVisibleDanmakus.forEachSync(this.mConsumer);
                RetainerState retainerState = this.mConsumer.result();
                topPos = this.mConsumer.topPos;
                if (retainerState != null) {
                    lines = retainerState.lines;
                    firstItem = retainerState.firstItem;
                    removeItem = retainerState.removeItem;
                    shown = retainerState.shown;
                    willHit = retainerState.willHit;
                }
                if (isOutOfVerticalEdge = this.isOutVerticalEdge(false, drawItem, disp, topPos, firstItem, null)) {
                    topPos = (float)disp.getHeight() - drawItem.paintHeight;
                    willHit = true;
                    lines = 1;
                } else {
                    if (topPos >= (float)disp.getAllMarginTop()) {
                        willHit = false;
                    }
                    if (removeItem != null) {
                        --lines;
                    }
                }
            }
            if (verifier != null && verifier.skipLayout(drawItem, topPos, lines, willHit)) {
                return;
            }
            if (isOutOfVerticalEdge) {
                this.clear();
            }
            drawItem.layout(disp, drawItem.getLeft(), topPos);
            if (!shown) {
                this.mVisibleDanmakus.removeItem(removeItem);
                this.mVisibleDanmakus.addItem(drawItem);
            }
        }

        @Override
        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos < (float)disp.getAllMarginTop() || firstItem != null && firstItem.getBottom() != (float)disp.getHeight();
        }

        @Override
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }

        protected class RetainerConsumer
        extends IDanmakus.Consumer<BaseDanmaku, RetainerState> {
            public IDisplayer disp;
            int lines = 0;
            public BaseDanmaku removeItem = null;
            public BaseDanmaku firstItem = null;
            public BaseDanmaku drawItem = null;
            boolean willHit = false;
            float topPos;

            protected RetainerConsumer() {
            }

            @Override
            public void before() {
                this.lines = 0;
                this.firstItem = null;
                this.removeItem = null;
                this.willHit = false;
            }

            @Override
            public int accept(BaseDanmaku item) {
                if (AlignBottomRetainer.this.mCancelFixingFlag) {
                    return 1;
                }
                ++this.lines;
                if (item == this.drawItem) {
                    this.removeItem = null;
                    this.willHit = false;
                    return 1;
                }
                if (this.firstItem == null) {
                    this.firstItem = item;
                    if (this.firstItem.getBottom() != (float)this.disp.getHeight()) {
                        return 1;
                    }
                }
                if (this.topPos < (float)this.disp.getAllMarginTop()) {
                    this.removeItem = null;
                    return 1;
                }
                this.willHit = DanmakuUtils.willHitInDuration(this.disp, item, this.drawItem, this.drawItem.getDuration(), this.drawItem.getTimer().currMillisecond);
                if (!this.willHit) {
                    this.removeItem = item;
                    return 1;
                }
                this.topPos = item.getTop() - (float)this.disp.getMargin() - this.drawItem.paintHeight;
                return 0;
            }

            @Override
            public RetainerState result() {
                RetainerState retainerState = new RetainerState();
                retainerState.lines = this.lines;
                retainerState.firstItem = this.firstItem;
                retainerState.removeItem = this.removeItem;
                retainerState.willHit = this.willHit;
                return retainerState;
            }
        }
    }

    private static class FTDanmakusRetainer
    extends AlignTopRetainer {
        private FTDanmakusRetainer() {
        }

        @Override
        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos + drawItem.paintHeight > (float)disp.getHeight();
        }
    }

    private static class AlignTopRetainer
    implements IDanmakusRetainer {
        protected Danmakus mVisibleDanmakus = new Danmakus(1);
        protected boolean mCancelFixingFlag = false;
        protected RetainerConsumer mConsumer = new RetainerConsumer();

        private AlignTopRetainer() {
        }

        @Override
        public void fix(BaseDanmaku drawItem, IDisplayer disp, Verifier verifier) {
            if (drawItem.isOutside()) {
                return;
            }
            float topPos = disp.getAllMarginTop();
            int lines = 0;
            boolean shown = drawItem.isShown();
            boolean willHit = !shown && !this.mVisibleDanmakus.isEmpty();
            boolean isOutOfVertialEdge = false;
            BaseDanmaku removeItem = null;
            int margin = disp.getMargin();
            if (!shown) {
                this.mCancelFixingFlag = false;
                BaseDanmaku insertItem = null;
                BaseDanmaku firstItem = null;
                BaseDanmaku lastItem = null;
                BaseDanmaku minRightRow = null;
                boolean overwriteInsert = false;
                this.mConsumer.disp = disp;
                this.mConsumer.drawItem = drawItem;
                this.mVisibleDanmakus.forEachSync(this.mConsumer);
                RetainerState retainerState = this.mConsumer.result();
                if (retainerState != null) {
                    lines = retainerState.lines;
                    insertItem = retainerState.insertItem;
                    firstItem = retainerState.firstItem;
                    lastItem = retainerState.lastItem;
                    minRightRow = retainerState.minRightRow;
                    overwriteInsert = retainerState.overwriteInsert;
                    shown = retainerState.shown;
                    willHit = retainerState.willHit;
                }
                boolean checkEdge = true;
                if (insertItem != null) {
                    topPos = lastItem != null ? lastItem.getBottom() + (float)margin : insertItem.getTop();
                    if (insertItem != drawItem) {
                        removeItem = insertItem;
                        shown = false;
                    }
                } else if (overwriteInsert && minRightRow != null) {
                    topPos = minRightRow.getTop();
                    checkEdge = false;
                    shown = false;
                } else if (lastItem != null) {
                    topPos = lastItem.getBottom() + (float)margin;
                    willHit = false;
                } else if (firstItem != null) {
                    topPos = firstItem.getTop();
                    removeItem = firstItem;
                    shown = false;
                } else {
                    topPos = disp.getAllMarginTop();
                }
                if (checkEdge) {
                    isOutOfVertialEdge = this.isOutVerticalEdge(overwriteInsert, drawItem, disp, topPos, firstItem, lastItem);
                }
                if (isOutOfVertialEdge) {
                    topPos = disp.getAllMarginTop();
                    willHit = true;
                    lines = 1;
                } else if (removeItem != null) {
                    --lines;
                }
                if (topPos == (float)disp.getAllMarginTop()) {
                    shown = false;
                }
            }
            if (verifier != null && verifier.skipLayout(drawItem, topPos, lines, willHit)) {
                return;
            }
            if (isOutOfVertialEdge) {
                this.clear();
            }
            drawItem.layout(disp, drawItem.getLeft(), topPos);
            if (!shown) {
                this.mVisibleDanmakus.removeItem(removeItem);
                this.mVisibleDanmakus.addItem(drawItem);
            }
        }

        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos < (float)disp.getAllMarginTop() || firstItem != null && firstItem.getTop() > 0.0f || topPos + drawItem.paintHeight > (float)disp.getHeight();
        }

        @Override
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }

        protected class RetainerConsumer
        extends IDanmakus.Consumer<BaseDanmaku, RetainerState> {
            public IDisplayer disp;
            int lines = 0;
            public BaseDanmaku insertItem = null;
            public BaseDanmaku firstItem = null;
            public BaseDanmaku lastItem = null;
            public BaseDanmaku minRightRow = null;
            public BaseDanmaku drawItem = null;
            boolean overwriteInsert = false;
            boolean shown = false;
            boolean willHit = false;

            protected RetainerConsumer() {
            }

            @Override
            public void before() {
                this.lines = 0;
                this.minRightRow = null;
                this.lastItem = null;
                this.firstItem = null;
                this.insertItem = null;
                this.willHit = false;
                this.shown = false;
                this.overwriteInsert = false;
            }

            @Override
            public int accept(BaseDanmaku item) {
                if (AlignTopRetainer.this.mCancelFixingFlag) {
                    return 1;
                }
                ++this.lines;
                if (item == this.drawItem) {
                    this.insertItem = item;
                    this.lastItem = null;
                    this.shown = true;
                    this.willHit = false;
                    return 1;
                }
                if (this.firstItem == null) {
                    this.firstItem = item;
                }
                if (this.drawItem.paintHeight + item.getTop() > (float)this.disp.getHeight()) {
                    this.overwriteInsert = true;
                    return 1;
                }
                if (this.minRightRow == null) {
                    this.minRightRow = item;
                } else if (this.minRightRow.getRight() >= item.getRight()) {
                    this.minRightRow = item;
                }
                this.willHit = DanmakuUtils.willHitInDuration(this.disp, item, this.drawItem, this.drawItem.getDuration(), this.drawItem.getTimer().currMillisecond);
                if (!this.willHit) {
                    this.insertItem = item;
                    return 1;
                }
                this.lastItem = item;
                return 0;
            }

            @Override
            public RetainerState result() {
                RetainerState retainerState = new RetainerState();
                retainerState.lines = this.lines;
                retainerState.firstItem = this.firstItem;
                retainerState.insertItem = this.insertItem;
                retainerState.lastItem = this.lastItem;
                retainerState.minRightRow = this.minRightRow;
                retainerState.overwriteInsert = this.overwriteInsert;
                retainerState.shown = this.shown;
                retainerState.willHit = this.willHit;
                return retainerState;
            }
        }
    }

    private static class RetainerState {
        public int lines = 0;
        public BaseDanmaku insertItem = null;
        public BaseDanmaku firstItem = null;
        public BaseDanmaku lastItem = null;
        public BaseDanmaku minRightRow = null;
        public BaseDanmaku removeItem = null;
        public boolean overwriteInsert = false;
        public boolean shown = false;
        public boolean willHit = false;

        private RetainerState() {
        }
    }

    public static interface IDanmakusRetainer {
        public void fix(BaseDanmaku var1, IDisplayer var2, Verifier var3);

        public void clear();
    }

    public static interface Verifier {
        public boolean skipLayout(BaseDanmaku var1, float var2, int var3, boolean var4);
    }
}

